/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.task;

import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAttributeContext;
import com.atlassian.stash.pull.PullRequestAttributeProvider;
import com.atlassian.stash.task.TaskCount;
import com.atlassian.stash.task.TaskState;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCountProvider
implements PullRequestAttributeProvider {
    public static final Map<TaskState, String> ATTRIBUTE_KEYS = TaskCountProvider.createAttributeKeys();
    private static final Function<PullRequest, InternalPullRequest> TO_INTERNAL_PULL_REQUEST = new Function<PullRequest, InternalPullRequest>(){

        public InternalPullRequest apply(PullRequest pullRequest) {
            return InternalConverter.convertToInternalPullRequest((PullRequest)pullRequest);
        }
    };
    private final InternalTaskService taskService;

    @Autowired
    public TaskCountProvider(InternalTaskService taskService) {
        this.taskService = taskService;
    }

    public void provideAttributes(@Nonnull PullRequestAttributeContext context) {
        Set internalPullRequests = Chainable.chain((Iterable)context).transform(TO_INTERNAL_PULL_REQUEST).toSet();
        Map counts = this.taskService.countForContexts((Iterable)internalPullRequests);
        for (Map.Entry e : counts.entrySet()) {
            for (TaskState t : TaskState.values()) {
                context.addAttribute((PullRequest)e.getKey(), ATTRIBUTE_KEYS.get(t), Long.toString(((TaskCount)e.getValue()).getCount(t)));
            }
        }
    }

    private static Map<TaskState, String> createAttributeKeys() {
        ImmutableMap.Builder attributeKeys = ImmutableMap.builder();
        for (TaskState state : TaskState.values()) {
            attributeKeys.put((Object)state, (Object)(state.name().toLowerCase() + "TaskCount"));
        }
        return attributeKeys.build();
    }
}

