/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification;

import com.atlassian.stash.commit.CommitDiscussion;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.notification.NotificationAddresser;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.notification.Notification;
import com.atlassian.stash.notification.commit.CommitDiscussionNotification;
import com.atlassian.stash.notification.pull.PullRequestNotification;
import com.atlassian.stash.notification.pull.PullRequestReviewerAddedNotification;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.watcher.Watchable;
import com.atlassian.stash.watcher.Watcher;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WatcherNotificationAddresser
implements NotificationAddresser {
    private static final Logger log = LoggerFactory.getLogger(WatcherNotificationAddresser.class);
    private final InternalWatcherService watcherService;
    private final PermissionService permissionService;
    private static final Function<Watcher, StashUser> WATCHER_TO_STASH_USER = new Function<Watcher, StashUser>(){

        public StashUser apply(Watcher watcher) {
            return watcher.getUser();
        }
    };

    @Autowired
    public WatcherNotificationAddresser(InternalWatcherService watcherService, PermissionService permissionService) {
        this.watcherService = watcherService;
        this.permissionService = permissionService;
    }

    @Override
    public Iterable<StashUser> getRecipients(Notification notification) {
        if (notification instanceof PullRequestReviewerAddedNotification) {
            return ((PullRequestReviewerAddedNotification)notification).getAddedReviewers();
        }
        if (notification instanceof PullRequestNotification) {
            InternalPullRequest internalPullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)((PullRequestNotification)notification).getPullRequest());
            return this.getWatchers((InternalWatchable)internalPullRequest);
        }
        if (notification instanceof CommitDiscussionNotification) {
            InternalCommitDiscussion internalCommitDiscussion = InternalConverter.convertToInternalCommitDiscussion((CommitDiscussion)((CommitDiscussionNotification)notification).getCommitDiscussion());
            return this.getWatchers((InternalWatchable)internalCommitDiscussion);
        }
        return Collections.emptyList();
    }

    private Iterable<StashUser> getWatchers(InternalWatchable watchable) {
        InternalRepository repository = watchable.getScopeRepository();
        Predicate<StashUser> permsCheck = new Predicate<StashUser>((Repository)repository){
            final /* synthetic */ Repository val$repository;
            {
                this.val$repository = repository;
            }

            public boolean apply(StashUser user) {
                boolean hasEmail = StringUtils.isNotEmpty((String)user.getEmailAddress());
                boolean licensed = WatcherNotificationAddresser.this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
                boolean hasRead = WatcherNotificationAddresser.this.permissionService.hasRepositoryPermission(user, this.val$repository, Permission.REPO_READ);
                if (!(!log.isDebugEnabled() || hasEmail && licensed && hasRead)) {
                    log.debug("Notification not being sent to {}: hasEmailAddress: {} licensed: {} hasReadOn({}/{}): {}", new Object[]{user.getName(), hasEmail, licensed, this.val$repository.getProject().getKey(), this.val$repository.getSlug(), hasRead});
                }
                return hasEmail && licensed && hasRead;
            }
        };
        return Chainable.chain((Iterable)this.watcherService.findWatchers((Watchable)watchable)).transform(WATCHER_TO_STASH_USER).filter((Predicate)permsCheck);
    }
}

