/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.hibernate.DataSourceConfiguration;
import com.atlassian.stash.internal.maintenance.LatchAndDrainDatabaseBackupStep;
import com.atlassian.stash.internal.maintenance.LatchAndDrainDatabaseMigrationStep;
import com.atlassian.stash.internal.maintenance.LatchAndDrainDatabaseStep;
import com.atlassian.stash.internal.maintenance.LatchAndDrainScmStep;
import com.atlassian.stash.internal.maintenance.MaintenanceModePhase;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.ReleaseAffixedDatabaseStep;
import com.atlassian.stash.internal.maintenance.UnlatchDatabaseStep;
import com.atlassian.stash.internal.maintenance.UnlatchScmStep;
import com.atlassian.stash.internal.maintenance.backup.ActiveObjectsBackupStep;
import com.atlassian.stash.internal.maintenance.backup.BackupClientPlaceholderStep;
import com.atlassian.stash.internal.maintenance.backup.BackupPhase;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.atlassian.stash.internal.maintenance.backup.BackupTask;
import com.atlassian.stash.internal.maintenance.backup.ChangelogsBackupStep;
import com.atlassian.stash.internal.maintenance.backup.ConfigurationBackupStep;
import com.atlassian.stash.internal.maintenance.backup.DatabaseBackupStep;
import com.atlassian.stash.internal.maintenance.backup.ExternalBackupTask;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.maintenance.migration.DatabaseMigrationTask;
import com.atlassian.stash.internal.maintenance.migration.DatabaseSetupTask;
import com.atlassian.stash.internal.maintenance.migration.FinalizeMigrationStep;
import com.atlassian.stash.internal.maintenance.migration.MigrationState;
import com.atlassian.stash.internal.maintenance.restore.ActiveObjectsRestoreStep;
import com.atlassian.stash.internal.maintenance.restore.DatabaseRestoreStep;
import com.atlassian.stash.internal.maintenance.restore.RestorePhase;
import com.atlassian.stash.internal.maintenance.restore.RestoreState;
import com.atlassian.stash.internal.maintenance.restore.UnpackBackupFilesStep;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.StringValueResolver;

@Component(value="maintenanceTaskFactory")
public class SpringMaintenanceTaskFactory
implements MaintenanceTaskFactory {
    private final ConfigurableBeanFactory beanFactory;
    private final StringValueResolver stringValueResolver;
    private final DatabaseManager databaseManager;

    @Autowired
    public SpringMaintenanceTaskFactory(ApplicationContext applicationContext, DatabaseManager databaseManager) {
        this.beanFactory = (ConfigurableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        this.databaseManager = databaseManager;
        this.stringValueResolver = new StringValueResolver(){

            public String resolveStringValue(String s) {
                return SpringMaintenanceTaskFactory.this.beanFactory.resolveEmbeddedValue(s);
            }
        };
    }

    @Override
    @Nonnull
    public ActiveObjectsRestoreStep activeObjectsRestoreStep(@Nonnull RestoreState state) {
        return this.create(ActiveObjectsRestoreStep.class, "restoreState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public BackupTask backupTask() {
        return this.create(BackupTask.class);
    }

    @Override
    @Nonnull
    public ExternalBackupTask externalBackupTask() {
        return this.create(ExternalBackupTask.class);
    }

    @Override
    @Nonnull
    public ActiveObjectsBackupStep activeObjectsBackupStep(@Nonnull BackupState state) {
        return this.create(ActiveObjectsBackupStep.class, "backupState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public BackupClientPlaceholderStep backupClientBackupStep() {
        return this.create(BackupClientPlaceholderStep.class);
    }

    @Override
    @Nonnull
    public BackupPhase.Builder backupPhaseBuilder(@Nonnull BackupState state) {
        return this.create(BackupPhase.Builder.class, "backupState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public ChangelogsBackupStep changelogsBackupStep(@Nonnull BackupState state) {
        return this.create(ChangelogsBackupStep.class, "backupState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public ConfigurationBackupStep configurationBackupStep(@Nonnull BackupState state) {
        return this.create(ConfigurationBackupStep.class, "backupState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public DatabaseBackupStep databaseBackupStep(@Nonnull BackupState state) {
        return this.create(DatabaseBackupStep.class, "backupState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public DatabaseRestoreStep databaseRestoreStep(@Nonnull RestoreState state) {
        return this.create(DatabaseRestoreStep.class, "restoreState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public FinalizeMigrationStep finalizeMigrationStep(@Nonnull MigrationState state) {
        return this.create(FinalizeMigrationStep.class, "restoreState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public LatchAndDrainDatabaseStep latchAndDrainDatabaseMigrationStep(@Nonnull LatchMode latchMode) {
        return this.create(LatchAndDrainDatabaseMigrationStep.class, "latchMode", latchMode);
    }

    @Override
    @Nonnull
    public LatchAndDrainDatabaseStep latchAndDrainDatabaseBackupStep(@Nonnull LatchMode latchMode) {
        return this.create(LatchAndDrainDatabaseBackupStep.class, "latchMode", latchMode);
    }

    @Override
    @Nonnull
    public LatchAndDrainScmStep latchAndDrainScmStep(@Nonnull LatchMode latchMode) {
        return this.create(LatchAndDrainScmStep.class, "latchMode", latchMode);
    }

    @Override
    @Nonnull
    public MaintenanceModePhase.Builder maintenanceModePhaseBuilder() {
        return this.create(MaintenanceModePhase.Builder.class);
    }

    @Override
    @Nonnull
    public DatabaseMigrationTask migrationTask(@Nonnull DataSourceConfiguration configuration) {
        return this.create(DatabaseMigrationTask.class, "targetDatabase", this.databaseManager.prepareDatabase((DataSourceConfiguration)Preconditions.checkNotNull((Object)configuration, (Object)"configuration")));
    }

    @Override
    @Nonnull
    public ReleaseAffixedDatabaseStep releaseAffixedDatabaseStep() {
        return this.create(ReleaseAffixedDatabaseStep.class);
    }

    @Override
    @Nonnull
    public RestorePhase.Builder restorePhaseBuilder(@Nonnull RestoreState state) {
        return this.create(RestorePhase.Builder.class, "restoreState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    @Override
    @Nonnull
    public DatabaseSetupTask setupTask(@Nonnull DataSourceConfiguration configuration) {
        return this.create(DatabaseSetupTask.class, "targetDatabase", this.databaseManager.prepareDatabase((DataSourceConfiguration)Preconditions.checkNotNull((Object)configuration, (Object)"configuration")));
    }

    @Override
    @Nonnull
    public UnlatchDatabaseStep unlatchDatabaseStep(@Nonnull LatchMode latchMode, DatabaseHandle databaseHandle) {
        return this.create(UnlatchDatabaseStep.Builder.class, "latchMode", latchMode).target(databaseHandle).build();
    }

    @Override
    @Nonnull
    public UnlatchScmStep unlatchScmStep(@Nonnull LatchMode latchMode) {
        return this.create(UnlatchScmStep.class, "latchMode", latchMode);
    }

    @Override
    @Nonnull
    public UnpackBackupFilesStep unpackBackupFilesStep(@Nonnull MigrationState state) {
        return this.create(UnpackBackupFilesStep.class, "migrationState", Preconditions.checkNotNull((Object)state, (Object)"state"));
    }

    private <T> T create(Class<T> clazz) {
        return this.create(clazz, null, null);
    }

    private <T> T create(Class<T> clazz, String contextBeanName, Object context) {
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory((BeanFactory)this.beanFactory);
        factory.copyConfigurationFrom(this.beanFactory);
        factory.addEmbeddedValueResolver(this.stringValueResolver);
        if (context != null) {
            Preconditions.checkArgument((contextBeanName != null ? 1 : 0) != 0, (Object)"no context bean name was provided");
            factory.registerSingleton(contextBeanName, context);
        }
        return clazz.cast(factory.autowire(clazz, 3, false));
    }
}

