/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.stash.internal.mail.JavaMailSenderFactory;
import com.atlassian.stash.mail.MailHostConfiguration;
import com.atlassian.stash.mail.MailProtocol;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Component;

@Component(value="javaMailSenderFactory")
public class DefaultJavaMailSenderFactory
implements JavaMailSenderFactory {
    private static final String SMTP = "smtp";
    private static final String SMTPS = "smtps";
    private static final String MAIL_SMTP = "mail.smtp";
    private static final String MAIL_SMTPS = "mail.smtps";
    private static final String SMTP_ENABLE_STARTTLS = "mail.smtp.starttls.enable";
    private static final String SMTP_REQUIRE_STARTTLS = "mail.smtp.starttls.required";
    private final String cryptoProtocols;
    private final String cryptoCiphers;

    @Autowired
    public DefaultJavaMailSenderFactory(@Value(value="${mail.crypto.protocols}") String cryptoProtocols, @Value(value="${mail.crypto.ciphers}") String cryptoCiphers) {
        this.cryptoProtocols = cryptoProtocols;
        this.cryptoCiphers = cryptoCiphers;
    }

    public JavaMailSenderImpl create(MailHostConfiguration configuration, int connectTimeout, int sendTimeout) {
        if (configuration == null || StringUtils.isBlank((String)configuration.getHostname())) {
            return null;
        }
        String prefix = configuration.getProtocol() == MailProtocol.SMTP ? MAIL_SMTP : MAIL_SMTPS;
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setDefaultEncoding("UTF-8");
        sender.setHost(configuration.getHostname());
        if (configuration.getPort() != null) {
            sender.setPort(configuration.getPort().intValue());
        }
        Properties properties = new Properties();
        sender.setProtocol(configuration.getProtocol().name().toLowerCase(Locale.US));
        if (configuration.getProtocol() == MailProtocol.SMTPS || configuration.isUseStartTls()) {
            if (StringUtils.isNotBlank((String)this.cryptoProtocols)) {
                properties.put(DefaultJavaMailSenderFactory.sslProtocolsProp(prefix), this.cryptoProtocols);
            }
            if (StringUtils.isNotBlank((String)this.cryptoCiphers)) {
                properties.put(DefaultJavaMailSenderFactory.sslCiphersProp(prefix), this.cryptoCiphers);
            }
        }
        if (configuration.getProtocol() == MailProtocol.SMTP) {
            if (configuration.isUseStartTls()) {
                properties.setProperty(SMTP_ENABLE_STARTTLS, Boolean.TRUE.toString());
            }
            if (configuration.isRequireStartTls()) {
                properties.setProperty(SMTP_REQUIRE_STARTTLS, Boolean.TRUE.toString());
            }
        }
        if (connectTimeout > 0) {
            properties.setProperty(DefaultJavaMailSenderFactory.connectionTimeoutProp(prefix), String.valueOf(connectTimeout));
        }
        if (sendTimeout > 0) {
            properties.setProperty(DefaultJavaMailSenderFactory.sendTimeoutProp(prefix), String.valueOf(sendTimeout));
        }
        if (StringUtils.isNotBlank((String)configuration.getUsername())) {
            properties.setProperty(DefaultJavaMailSenderFactory.authProp(prefix), Boolean.TRUE.toString());
            sender.setUsername(configuration.getUsername());
            if (StringUtils.isNotBlank((String)configuration.getPassword())) {
                sender.setPassword(configuration.getPassword());
            }
        }
        sender.setJavaMailProperties(properties);
        return sender;
    }

    private static String authProp(String prefix) {
        return prefix + ".auth";
    }

    private static String connectionTimeoutProp(String prefix) {
        return prefix + ".connectiontimeout";
    }

    private static String sendTimeoutProp(String prefix) {
        return prefix + ".timeout";
    }

    private static String sslProtocolsProp(String prefix) {
        return prefix + ".ssl.protocols";
    }

    private static String sslCiphersProp(String prefix) {
        return prefix + ".ssl.ciphers";
    }
}

