/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.stash.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.stash.internal.crowd.CrowdControl;
import com.atlassian.stash.internal.license.LicensedUserCountCache;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.annotations.VisibleForTesting;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component(value="licensedUserCountCache")
public class DefaultLicensedUserCountCache
implements LicensedUserCountCache {
    @VisibleForTesting
    static final String CACHE_NAME = "com.atlassian.stash.internal.license.LicensedUserCountCache";
    @VisibleForTesting
    static final String CACHE_KEY = "count";
    private static final Logger log = LoggerFactory.getLogger(DefaultLicensedUserCountCache.class);
    private final Cache cache;
    private final CrowdControl crowdControl;
    private final SynchronisationStatusManager crowdSyncStatusManager;
    private final ScheduledExecutorService executorService;
    private final InternalPermissionService permissionService;
    private final AtomicBoolean repopulateCacheAfterCrowdSync;
    private final IAtomicLong repopulateCounter;

    @Autowired
    public DefaultLicensedUserCountCache(CacheManager cacheManager, CrowdControl crowdControl, SynchronisationStatusManager crowdSyncStatusManager, ScheduledExecutorService executorService, InternalPermissionService permissionService, HazelcastInstance hazelcast) {
        this.cache = cacheManager.getCache(CACHE_NAME);
        this.crowdControl = crowdControl;
        this.crowdSyncStatusManager = crowdSyncStatusManager;
        this.executorService = executorService;
        this.permissionService = permissionService;
        this.repopulateCacheAfterCrowdSync = new AtomicBoolean();
        this.repopulateCounter = hazelcast.getAtomicLong("com.atlassian.stash.internal.license.LicensedUserCountCache.repopulateCounter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() {
        Integer count = this.getCachedCount();
        if (count == null) {
            DefaultLicensedUserCountCache defaultLicensedUserCountCache = this;
            synchronized (defaultLicensedUserCountCache) {
                count = this.getCachedCount();
                if (count == null) {
                    count = this.repopulateCacheNow();
                }
            }
        }
        return count;
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            this.repopulateCacheIfLicensedGroup(event.getGroupName());
        }
    }

    @EventListener
    public void onDirectorySynchronisedEvent(RemoteDirectorySynchronisedEvent event) {
        if (this.repopulateCacheAfterCrowdSync.compareAndSet(true, false)) {
            log.debug("Directory (id={}) synchronization complete. repopulating license cache.", (Object)event.getRemoteDirectory().getDirectoryId());
            this.repopulateCacheLater();
        }
    }

    @EventListener
    public void onPermissionGrantedEvent(GlobalPermissionGrantedEvent event) {
        if (log.isDebugEnabled()) {
            StashUser affectedUser = event.getAffectedUser();
            if (affectedUser == null) {
                log.debug("{} granted to group {}. repopulating license cache.", (Object)event.getPermission(), (Object)event.getAffectedGroup());
            } else {
                log.debug("{} granted to user {}. repopulating license cache.", (Object)event.getPermission(), (Object)affectedUser.getName());
            }
        }
        this.repopulateCacheLater();
    }

    @EventListener
    public void onPermissionRevokedEvent(GlobalPermissionRevokedEvent event) {
        if (log.isDebugEnabled()) {
            StashUser affectedUser = event.getAffectedUser();
            if (affectedUser == null) {
                log.debug("{} revoked from group {}. repopulating license cache.", (Object)event.getPermission(), (Object)event.getAffectedGroup());
            } else {
                log.debug("{} revoked from user {}. repopulating license cache.", (Object)event.getPermission(), (Object)affectedUser.getName());
            }
        }
        this.repopulateCacheLater();
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent event) {
        log.debug("Directory (id={}) was updated. repopulating license cache.", (Object)event.getDirectory().getId());
        this.repopulateCacheLater();
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            this.repopulateCacheIfLicensedGroup(event.getGroupName());
        }
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            this.repopulateCacheIfLicensedGroup(event.getGroupName());
        }
    }

    @EventListener
    public void onUserDeletedEvent(UserDeletedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            log.debug("User (name={}) was deleted. repopulating license cache.", (Object)event.getUsername());
            this.repopulateCacheLater();
        }
    }

    @EventListener
    public void onUserUpdatedEvent(UserUpdatedEvent event) {
        if (this.shouldRepopulateCache((DirectoryEvent)event)) {
            log.debug("User (name={}) was updated. repopulating license cache.", (Object)event.getUser().getName());
            this.repopulateCacheLater();
        }
    }

    private void repopulateCacheIfLicensedGroup(String groupName) {
        if (this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, groupName)) {
            this.repopulateCacheLater();
        } else {
            PageRequest request = PageUtils.newRequest((int)0, (int)10);
            Page licensedGroups = this.permissionService.getGrantedGroups(Permission.LICENSED_USER, request);
            if (!licensedGroups.getIsLastPage()) {
                this.repopulateCacheLater();
            } else {
                for (String licensedGroup : licensedGroups.getValues()) {
                    if (!this.crowdControl.isGroupMemberOfGroup(groupName, licensedGroup)) continue;
                    this.repopulateCacheLater();
                    break;
                }
            }
        }
    }

    @VisibleForTesting
    void putCachedCount(int count) {
        this.cache.put((Object)CACHE_KEY, (Object)count);
    }

    private Integer getCachedCount() {
        return (Integer)this.cache.get((Object)CACHE_KEY, Integer.class);
    }

    private void repopulateCacheLater() {
        if (this.repopulateCounter.incrementAndGet() == 1L) {
            this.scheduleCacheRepopulation();
        }
    }

    private int repopulateCacheNow() {
        int count = this.permissionService.getUsersWithPermission(Permission.LICENSED_USER).size();
        this.putCachedCount(count);
        return count;
    }

    private void scheduleCacheRepopulation() {
        this.executorService.submit(new RepopulateLicensedUserCacheJob());
    }

    private void scheduleCacheRepopulation(long delay, TimeUnit unit) {
        this.executorService.schedule(new RepopulateLicensedUserCacheJob(), delay, unit);
    }

    private boolean shouldRepopulateCache(DirectoryEvent event) {
        if (this.crowdSyncStatusManager.getDirectorySynchronisationInformation(event.getDirectory()).isSynchronising()) {
            log.debug("Directory (id={}) synchronization is in progress. Delaying repopulating license cache.", (Object)event.getDirectory().getId());
            this.repopulateCacheAfterCrowdSync.set(true);
            return false;
        }
        return true;
    }

    private class RepopulateLicensedUserCacheJob
    implements Runnable {
        private RepopulateLicensedUserCacheJob() {
        }

        @Override
        public void run() {
            long counter = DefaultLicensedUserCountCache.this.repopulateCounter.get();
            try {
                DefaultLicensedUserCountCache.this.repopulateCacheNow();
                if (DefaultLicensedUserCountCache.this.repopulateCounter.addAndGet(-counter) > 0L) {
                    DefaultLicensedUserCountCache.this.scheduleCacheRepopulation();
                }
            }
            catch (Exception e) {
                log.info("An error occurred when repopulating the licensed user count cache.", (Throwable)e);
                DefaultLicensedUserCountCache.this.scheduleCacheRepopulation(10L, TimeUnit.SECONDS);
            }
        }
    }
}

