/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import com.atlassian.stash.internal.language.InternalLanguageService;
import com.atlassian.stash.internal.language.Language;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="localeHolder")
public class DefaultLocaleHolder
implements LocaleHolder {
    private final StashAuthenticationContext authenticationContext;
    private final InternalLanguageService languageService;
    private final InternalLocaleManager localeManager;
    private final InternalApplicationPropertiesService propertiesService;
    private volatile Map<Locale, Locale> installedLocales = ImmutableMap.of();

    @Autowired
    public DefaultLocaleHolder(StashAuthenticationContext authenticationContext, InternalLanguageService languageService, InternalApplicationPropertiesService propertiesService, InternalLocaleManager localeManager) {
        this.authenticationContext = authenticationContext;
        this.localeManager = localeManager;
        this.languageService = languageService;
        this.propertiesService = propertiesService;
    }

    @Nonnull
    public Iterable<Locale> getLocales(Locale ... overrides) {
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        return new LocaleBuilder().addAll(Arrays.asList(overrides)).add(this.findInstalledLocaleClosestMatch(this.localeManager.getLocale(this.authenticationContext.getCurrentUser()))).add(localeContext != null ? this.findInstalledLocaleClosestMatch(localeContext.getLocale()) : null).add(this.propertiesService.getLocale()).add(Locale.US).build();
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.cacheLocales();
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.cacheLocales();
    }

    private Locale findInstalledLocaleClosestMatch(Locale locale) {
        if (locale != null) {
            Locale first = this.installedLocales.get(locale);
            if (first != null) {
                return first;
            }
            return (Locale)Objects.firstNonNull((Object)this.installedLocales.get(new Locale(locale.getLanguage())), (Object)locale);
        }
        return null;
    }

    @VisibleForTesting
    void cacheLocales() {
        HashMap map = Maps.newHashMap();
        for (Language lang : this.languageService.getLanguages()) {
            if (StringUtils.isEmpty((String)lang.getLocale().getCountry())) continue;
            map.put(lang.getLocale(), lang.getLocale());
            map.put(new Locale(lang.getLocale().getLanguage()), lang.getLocale());
        }
        for (Language lang : this.languageService.getLanguages()) {
            if (!StringUtils.isEmpty((String)lang.getLocale().getCountry())) continue;
            map.put(lang.getLocale(), lang.getLocale());
        }
        this.installedLocales = map;
    }

    private static class LocaleBuilder {
        private final List<Locale> locales = Lists.newArrayList();

        private LocaleBuilder() {
        }

        public LocaleBuilder add(Locale locale) {
            if (locale != null) {
                this.addSubLocales(locale);
            }
            return this;
        }

        public LocaleBuilder addAll(Iterable<Locale> locales) {
            for (Locale locale : locales) {
                this.add(locale);
            }
            return this;
        }

        public List<Locale> build() {
            return this.locales;
        }

        private void addSubLocales(Locale locale) {
            for (Locale subLocale : LocaleUtils.localeLookupList((Locale)locale)) {
                if (this.locales.contains(subLocale)) {
                    return;
                }
                this.locales.add(subLocale);
            }
        }
    }
}

