/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hazelcast;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.cluster.ClusterNode;
import com.atlassian.stash.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.stash.event.cluster.ClusterNodeRejoinedEvent;
import com.atlassian.stash.event.cluster.ClusterNodeRemovedEvent;
import com.atlassian.stash.internal.cluster.HazelcastClusterNode;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HazelcastClusterListener {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterListener.class);
    private final EventPublisher eventPublisher;
    private final HazelcastInstance hazelcast;
    private volatile String listenerId;

    @Autowired
    public HazelcastClusterListener(EventPublisher eventPublisher, HazelcastInstance hazelcast) {
        this.eventPublisher = eventPublisher;
        this.hazelcast = hazelcast;
    }

    @PostConstruct
    public void register() {
        this.listenerId = this.hazelcast.getCluster().addMembershipListener(new MembershipListener(){
            private final ConcurrentMap<String, Long> lastModifiedByMember = new ConcurrentHashMap<String, Long>();

            public void memberAdded(MembershipEvent membershipEvent) {
                long now = System.currentTimeMillis();
                Member member = membershipEvent.getMember();
                String nodeId = member.getStringAttribute("node.vm.id");
                Long lastChange = null;
                if (nodeId != null) {
                    lastChange = this.lastModifiedByMember.put(nodeId, now);
                } else {
                    log.warn("No '{}' attribute available for new member {}", (Object)"node.vm.id", (Object)member.getSocketAddress());
                }
                if (lastChange == null) {
                    HazelcastClusterListener.this.eventPublisher.publish((Object)new ClusterNodeAddedEvent((Object)HazelcastClusterListener.this, (ClusterNode)new HazelcastClusterNode(member), HazelcastClusterNode.transform(membershipEvent.getMembers())));
                } else {
                    HazelcastClusterListener.this.eventPublisher.publish((Object)new ClusterNodeRejoinedEvent((Object)HazelcastClusterListener.this, (ClusterNode)new HazelcastClusterNode(member), HazelcastClusterNode.transform(membershipEvent.getMembers()), lastChange.longValue(), now));
                }
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                Member member = membershipEvent.getMember();
                HazelcastClusterListener.this.eventPublisher.publish((Object)new ClusterNodeRemovedEvent((Object)HazelcastClusterListener.this, (ClusterNode)new HazelcastClusterNode(member), HazelcastClusterNode.transform(membershipEvent.getMembers())));
                String nodeId = member.getStringAttribute("node.vm.id");
                if (nodeId != null) {
                    this.lastModifiedByMember.put(nodeId, System.currentTimeMillis());
                }
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
    }

    @PreDestroy
    public boolean unregister() {
        String id = this.listenerId;
        return id != null && this.hazelcast.getCluster().removeMembershipListener(id);
    }
}

