/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.concurrent.VersionTracker;
import com.hazelcast.core.IMap;
import com.hazelcast.map.AbstractEntryProcessor;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;

public class HazelcastVersionTracker<K extends Serializable>
implements VersionTracker<K> {
    private final IMap<K, Integer> map;

    public HazelcastVersionTracker(IMap<K, Integer> map) {
        this.map = map;
    }

    public int get(@Nonnull K key) {
        Integer result = (Integer)this.map.putIfAbsent(key, (Object)0);
        return result == null ? 0 : result;
    }

    public int incrementAndGet(@Nonnull K key) {
        return (Integer)this.map.executeOnKey(key, new IncrementVersionProcessor());
    }

    public void increment(@Nonnull K key) {
        this.incrementAndGet(key);
    }

    public void incrementAll() {
        this.map.executeOnEntries(new IncrementVersionProcessor());
    }

    public static Integer inc(Integer value) {
        return value == Integer.MAX_VALUE ? 0 : value + 1;
    }

    private static class IncrementVersionProcessor<K extends Serializable>
    extends AbstractEntryProcessor<K, Integer> {
        private IncrementVersionProcessor() {
        }

        public Integer process(Map.Entry<K, Integer> entry) {
            Integer value = entry.getValue();
            value = value != null ? HazelcastVersionTracker.inc(value) : 1;
            entry.setValue(value);
            return value;
        }
    }
}

