/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.CommentAttributeContext;
import com.atlassian.stash.comment.CommentAttributeProvider;
import com.atlassian.stash.comment.CommentPropertyContext;
import com.atlassian.stash.comment.CommentPropertyProvider;
import com.atlassian.stash.comment.Commentable;
import com.atlassian.stash.comment.CommentableVisitor;
import com.atlassian.stash.commit.CommitDiscussion;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.content.AbstractProviderContext;
import com.atlassian.stash.internal.plugin.CommentAttributeProviderDescriptor;
import com.atlassian.stash.internal.plugin.CommentPropertyProviderDescriptor;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.ModuleDescriptorUtils;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class PluginCommentPostProcessor
implements CommentPostProcessor {
    private static final Predicate<InternalComment> HAS_PROPERTIES = new Predicate<InternalComment>(){

        public boolean apply(InternalComment comment) {
            return comment.hasAttributes() && comment.hasProperties();
        }
    };
    private final PluginAccessor pluginAccessor;

    public PluginCommentPostProcessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public InternalComment process(InternalCommentable entity, InternalComment comment) {
        if (HAS_PROPERTIES.apply((Object)comment)) {
            return comment;
        }
        Context context = new Context((Commentable)entity, (Comment)comment);
        this.enrich(context);
        return new Enricher(context).apply(comment);
    }

    @Override
    public List<InternalComment> processAll(InternalCommentable entity, List<InternalComment> comments) {
        Collection toProcess = Collections2.filter(comments, (Predicate)Predicates.not(HAS_PROPERTIES));
        Context context = new Context((Commentable)entity, toProcess);
        this.enrich(context);
        return ImmutableList.copyOf((Collection)Lists.transform(comments, (Function)new Enricher(context)));
    }

    private void enrich(Context context) {
        int commentCount = Iterables.size((Iterable)((Object)context));
        this.provideAttributes(context, commentCount);
        this.provideProperties(context, commentCount);
    }

    private Iterable<CommentAttributeProvider> getAttributeProviders() {
        return Chainable.chain((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(CommentAttributeProviderDescriptor.class)).transform(ModuleDescriptorUtils.toModule());
    }

    private Iterable<CommentPropertyProvider> getPropertyProviders() {
        return Chainable.chain((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(CommentPropertyProviderDescriptor.class)).transform(ModuleDescriptorUtils.toModule());
    }

    private void provideAttributes(Context context, int commentCount) {
        for (CommentAttributeProvider attributeProvider : this.getAttributeProviders()) {
            Timer timer = TimerUtils.start((String)String.format("%s.provideAttributes for %d comments", attributeProvider.getClass().getName(), commentCount));
            Throwable throwable = null;
            try {
                attributeProvider.provideAttributes((CommentAttributeContext)context);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (timer == null) continue;
                if (throwable != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                timer.close();
            }
        }
    }

    private void provideProperties(Context context, int commentCount) {
        for (CommentPropertyProvider propertyProvider : this.getPropertyProviders()) {
            Timer timer = TimerUtils.start((String)String.format("%s.provideProperties for %d comments", propertyProvider.getClass().getName(), commentCount));
            Throwable throwable = null;
            try {
                propertyProvider.provideProperties((CommentPropertyContext)context);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (timer == null) continue;
                if (throwable != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                timer.close();
            }
        }
    }

    private static class Enricher
    implements Function<InternalComment, InternalComment> {
        private final Context context;

        public Enricher(Context context) {
            this.context = context;
        }

        public InternalComment apply(InternalComment comment) {
            this.apply((Iterable<InternalComment>)ImmutableList.of((Object)comment));
            return comment;
        }

        private void apply(Iterable<InternalComment> comments) {
            for (InternalComment comment : comments) {
                if (!comment.hasAttributes()) {
                    comment.setAttributes(this.context.getAttributesFor(comment));
                }
                if (!comment.hasProperties()) {
                    comment.setProperties(this.context.getPropertiesFor(comment));
                }
                this.apply(comment.getComments());
            }
        }
    }

    private static class Context
    extends AbstractProviderContext<Comment>
    implements CommentAttributeContext,
    CommentPropertyContext {
        private final Commentable entity;

        private Context(Commentable entity, Comment comment) {
            this(entity, (Iterable<? extends Comment>)ImmutableList.of((Object)comment));
        }

        private Context(Commentable entity, Iterable<? extends Comment> comments) {
            super(comments);
            this.entity = entity;
        }

        public <T> T accept(@Nonnull CommentableVisitor<T> visitor) {
            Preconditions.checkNotNull(visitor, (Object)"visitor");
            if (this.entity instanceof PullRequest) {
                return (T)visitor.visit((PullRequest)this.entity);
            }
            if (this.entity instanceof CommitDiscussion) {
                return (T)visitor.visit((CommitDiscussion)this.entity);
            }
            throw new UnsupportedOperationException("Cannot visit " + this.entity.getClass());
        }
    }
}

