/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.user.InternalStashAuthenticationContext;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import javax.annotation.Nonnull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=StashAuthenticationContext.class)
@Component(value="authenticationContext")
public class DefaultStashAuthenticationContext
implements InternalStashAuthenticationContext,
StatefulService {
    public boolean isAuthenticated() {
        return this.getCurrentUser() != null;
    }

    public StashUser getCurrentUser() {
        StashUserAuthenticationToken token = this.getCurrentToken();
        return token != null ? token.getPrincipal() : null;
    }

    public StashUserAuthenticationToken getCurrentToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)authentication;
        }
        return null;
    }

    @Nonnull
    @NotProfiled
    public TransferableState getState() {
        final Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return new TransferableState(){

            public void apply() {
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }

            public void remove() {
                SecurityContextHolder.clearContext();
            }
        };
    }
}

