/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.audit;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.audit.AuditEntry;
import com.atlassian.stash.audit.Priority;
import com.atlassian.stash.event.StashEvent;
import com.atlassian.stash.event.pull.PullRequestApprovalEvent;
import com.atlassian.stash.event.pull.PullRequestDeclinedEvent;
import com.atlassian.stash.event.pull.PullRequestEvent;
import com.atlassian.stash.event.pull.PullRequestMergedEvent;
import com.atlassian.stash.event.pull.PullRequestOpenRequestedEvent;
import com.atlassian.stash.event.pull.PullRequestOpenedEvent;
import com.atlassian.stash.event.pull.PullRequestParticipantsUpdatedEvent;
import com.atlassian.stash.event.pull.PullRequestReopenedEvent;
import com.atlassian.stash.event.pull.PullRequestRolesUpdatedEvent;
import com.atlassian.stash.internal.audit.AbstractAuditEventListener;
import com.atlassian.stash.internal.audit.AuditEntryLoggingService;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestParticipant;
import com.atlassian.stash.request.RequestManager;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.UserUtils;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestEventListener
extends AbstractAuditEventListener {
    private static final Function<PullRequestParticipant, String> TO_PARTICIPANT_NAME = new Function<PullRequestParticipant, String>(){

        public String apply(PullRequestParticipant participant) {
            return participant.getUser().getName();
        }
    };

    @Autowired
    public PullRequestEventListener(AuditEntryLoggingService auditLoggingService, RequestManager requestManager, StashAuthenticationContext authContext, EventPublisher eventPublisher) {
        super(auditLoggingService, requestManager, authContext, eventPublisher);
    }

    @EventListener
    public void onPullRequestApproved(PullRequestApprovalEvent event) throws Exception {
        this.auditPullRequestEvent((PullRequestEvent)event, Collections.singletonMap("participant", event.getParticipant().getUser().getName()));
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent event) throws Exception {
        this.auditPullRequestEvent((PullRequestEvent)event, null);
    }

    @EventListener
    public void onPullRequestMerged(PullRequestMergedEvent event) throws Exception {
        this.auditPullRequestEvent((PullRequestEvent)event, Collections.singletonMap("changes", PullRequestEventListener.toMaps(event.getRefChanges())));
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) throws Exception {
        this.auditPullRequestEvent((PullRequestEvent)event, (Map<String, Object>)this.toOpeningExtrasMap(event.getPullRequest(), null));
    }

    @EventListener
    public void onPullRequestOpenRequested(PullRequestOpenRequestedEvent event) throws Exception {
        this.auditPullRequestEvent((PullRequestEvent)event, (Map<String, Object>)this.toOpeningExtrasMap(event.getPullRequest(), event.getReviewers()));
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) throws Exception {
        this.auditPullRequestEvent((PullRequestEvent)event, (Map<String, Object>)this.toOpeningExtrasMap(event.getPullRequest(), null));
    }

    @EventListener
    public void onPullRequestParticipantsUpdated(PullRequestParticipantsUpdatedEvent event) throws Exception {
        ImmutableMap.Builder<String, Object> builder = PullRequestEventListener.getMapBuilder();
        this.addPullRequestParticipantChangedDetails(builder, event.getAddedParticipants(), event.getRemovedParticipants());
        this.auditPullRequestEvent((PullRequestEvent)event, (Map<String, Object>)builder.build());
    }

    @EventListener
    public void onPullRequestRolesUpdated(PullRequestRolesUpdatedEvent event) throws Exception {
        ImmutableMap.Builder<String, Object> builder = PullRequestEventListener.getMapBuilder();
        this.addPullRequestParticipantChangedDetails(builder, event.getAddedReviewers(), event.getRemovedReviewers());
        this.auditPullRequestEvent((PullRequestEvent)event, (Map<String, Object>)builder.build());
    }

    private void addPullRequestParticipantChangedDetails(ImmutableMap.Builder<String, Object> builder, Set<StashUser> added, Set<StashUser> removed) {
        if (!added.isEmpty()) {
            builder.put((Object)"added", (Object)Collections2.transform(added, (Function)UserUtils.TO_USERNAME));
        }
        if (!removed.isEmpty()) {
            builder.put((Object)"removed", (Object)Collections2.transform(removed, (Function)UserUtils.TO_USERNAME));
        }
    }

    private void auditPullRequestEvent(PullRequestEvent event, Map<String, Object> extras) throws Exception {
        PullRequest pullRequest = event.getPullRequest();
        ImmutableMap.Builder<String, Object> builder = PullRequestEventListener.getMapBuilder();
        PullRequestEventListener.safePut(builder, "id", pullRequest.getId());
        if (extras != null) {
            builder.putAll(extras);
        }
        AuditEntry auditEntry = this.createAuditEntryBuilder((StashEvent)event).details(this.convertToJsonString(builder.build())).target(PullRequestEventListener.toProjectAndRepositoryString(pullRequest.getToRef().getRepository())).build();
        this.publish(event, auditEntry, Priority.LOW);
    }

    private ImmutableMap<String, Object> toOpeningExtrasMap(PullRequest pullRequest, Set<StashUser> reviewers) {
        ImmutableMap.Builder<String, Object> mapBuilder = PullRequestEventListener.getMapBuilder();
        if (CollectionUtils.isNotEmpty(reviewers)) {
            mapBuilder.put((Object)"reviewers", (Object)Collections2.transform(reviewers, (Function)UserUtils.TO_USERNAME));
        } else if (CollectionUtils.isNotEmpty((Collection)pullRequest.getReviewers())) {
            mapBuilder.put((Object)"reviewers", (Object)Collections2.transform((Collection)pullRequest.getReviewers(), TO_PARTICIPANT_NAME));
        }
        if (CollectionUtils.isNotEmpty((Collection)pullRequest.getParticipants())) {
            mapBuilder.put((Object)"participants", (Object)Collections2.transform((Collection)pullRequest.getParticipants(), TO_PARTICIPANT_NAME));
        }
        return mapBuilder.put((Object)"source", PullRequestEventListener.toProjectAndRepositoryMap(pullRequest.getFromRef().getRepository())).put((Object)"target", PullRequestEventListener.toProjectAndRepositoryMap(pullRequest.getToRef().getRepository())).build();
    }
}

