/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.watcher;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.watch.WatcherAddedEvent;
import com.atlassian.stash.event.watch.WatcherRemovedEvent;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcher;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.internal.watcher.WatcherDao;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.watcher.Watchable;
import com.atlassian.stash.watcher.Watcher;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="watcherService")
public class DefaultWatcherService
extends AbstractService
implements InternalWatcherService {
    private final StashAuthenticationContext authenticationContext;
    private final WatcherDao watcherDao;
    private final EventPublisher eventPublisher;

    @Autowired
    public DefaultWatcherService(StashAuthenticationContext authenticationContext, WatcherDao watcherDao, EventPublisher eventPublisher) {
        this.authenticationContext = authenticationContext;
        this.watcherDao = watcherDao;
        this.eventPublisher = eventPublisher;
    }

    @Nonnull
    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public Watcher addCurrentUserAsWatcher(@Nonnull InternalWatchable watchable) {
        return this.addUserAsWatcher(watchable, this.authenticationContext.getCurrentUser());
    }

    @Nonnull
    @Transactional
    public Watcher addUserAsWatcher(@Nonnull InternalWatchable watchable, @Nonnull StashUser user) {
        InternalWatcher watcher = this.watcherDao.findByWatchableAndUser((Watchable)watchable, user);
        if (watcher == null) {
            watcher = (InternalWatcher)this.watcherDao.create((Object)new InternalWatcher.Builder().user(InternalConverter.convertToInternalUser((StashUser)user)).watchable(watchable).build());
            this.eventPublisher.publish((Object)new WatcherAddedEvent((Object)this, (Watcher)watcher));
        }
        return watcher;
    }

    public long countWatchers(@Nonnull Watchable watchable) {
        return this.watcherDao.countWatchers(watchable);
    }

    @Nonnull
    public Set<? extends Watcher> findWatchers(@Nonnull Watchable watchable) {
        return this.watcherDao.findByWatchable(watchable);
    }

    @PreAuthorize(value="isAuthenticated()")
    public boolean isCurrentUserWatching(@Nonnull Watchable watchable) {
        return this.watcherDao.findByWatchableAndUser(watchable, this.authenticationContext.getCurrentUser()) != null;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional
    public boolean removeCurrentUserAsWatcher(@Nonnull InternalWatchable watchable) {
        return this.removeUserAsWatcher(watchable, this.authenticationContext.getCurrentUser());
    }

    @Transactional
    public boolean removeUserAsWatcher(@Nonnull InternalWatchable watchable, @Nonnull StashUser user) {
        InternalWatcher watcher = this.watcherDao.findByWatchableAndUser((Watchable)watchable, user);
        if (watcher == null) {
            return false;
        }
        this.watcherDao.delete((Object)watcher);
        this.eventPublisher.publish((Object)new WatcherRemovedEvent((Object)this, (Watcher)watcher));
        return true;
    }
}

