/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.event.RepositoryCreatedEvent;
import com.atlassian.stash.event.RepositoryCreationFailedEvent;
import com.atlassian.stash.event.RepositoryCreationRequestedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.event.RepositoryDeletionRequestedEvent;
import com.atlassian.stash.event.RepositoryForkFailedEvent;
import com.atlassian.stash.event.RepositoryForkRequestedEvent;
import com.atlassian.stash.event.RepositoryForkedEvent;
import com.atlassian.stash.event.RepositoryModificationRequestedEvent;
import com.atlassian.stash.event.RepositoryModifiedEvent;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.NoSuchProjectException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Throttled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.config.Feature;
import com.atlassian.stash.internal.config.FeatureManager;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.InternalProjectService;
import com.atlassian.stash.internal.repository.DefaultRepositorySupplier;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryService;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryOrder;
import com.atlassian.stash.internal.repository.RepositorySearchCriteria;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.project.PersonalProject;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectType;
import com.atlassian.stash.repository.AbstractRepositoryRequest;
import com.atlassian.stash.repository.ForkingDisabledException;
import com.atlassian.stash.repository.IllegalRepositoryStateException;
import com.atlassian.stash.repository.PersonalRepositoryDisabledException;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryCloneLinksRequest;
import com.atlassian.stash.repository.RepositoryCreateRequest;
import com.atlassian.stash.repository.RepositoryCreationCanceledException;
import com.atlassian.stash.repository.RepositoryDeletionCanceledException;
import com.atlassian.stash.repository.RepositoryForkCanceledException;
import com.atlassian.stash.repository.RepositoryForkRequest;
import com.atlassian.stash.repository.RepositoryModificationCanceledException;
import com.atlassian.stash.repository.RepositorySearchRequest;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.repository.RepositorySupplier;
import com.atlassian.stash.repository.RepositoryUpdateRequest;
import com.atlassian.stash.repository.RepositoryVisibility;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.DeleteCommandParameters;
import com.atlassian.stash.scm.FeatureUnsupportedScmException;
import com.atlassian.stash.scm.ScmFeature;
import com.atlassian.stash.scm.ScmProtocol;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.CancelState;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.NamedLink;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.util.SimpleCancelState;
import com.atlassian.stash.util.SimpleNamedLink;
import com.atlassian.stash.util.ValidationUtils;
import com.atlassian.stash.validation.groups.Create;
import com.atlassian.stash.validation.groups.Update;
import com.atlassian.utils.process.ProcessException;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@AvailableToPlugins(interfaces={RepositoryService.class, RepositorySupplier.class})
@Service(value="repositoryService")
public class DefaultRepositoryService
extends DefaultRepositorySupplier
implements InternalRepositoryService {
    private static final int MINIMUM_MAX_REPOSITORIES = 50;
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryService.class);
    private final StashAuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService executorService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final InternalPermissionService permissionService;
    private final PermissionPredicateFactory predicateFactory;
    private final InternalProjectService projectService;
    private final ApplicationPropertiesService propertiesService;
    private final InternalScmService scmService;
    private final SecureTokenGenerator tokenGenerator;
    private final TransactionTemplate transactionTemplate;
    private final Validator validator;
    private int maxRepositoriesPerPage;

    @Autowired
    public DefaultRepositoryService(StashAuthenticationContext authenticationContext, EventPublisher eventPublisher, ScheduledExecutorService executorService, FeatureManager featureManager, I18nService i18nService, PermissionPredicateFactory predicateFactory, InternalPermissionService permissionService, InternalProjectService projectService, ApplicationPropertiesService propertiesService, RepositoryDao repositoryDao, InternalScmService scmService, SecureTokenGenerator tokenGenerator, PlatformTransactionManager transactionManager, Validator validator) {
        super(repositoryDao);
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.predicateFactory = predicateFactory;
        this.projectService = projectService;
        this.propertiesService = propertiesService;
        this.scmService = scmService;
        this.tokenGenerator = tokenGenerator;
        this.validator = validator;
        this.maxRepositoriesPerPage = 50;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Secured(value="by the delegated method")
    @Transactional(readOnly=true)
    public int countByProject(@Nonnull Project project) {
        return this.permissionService.getCountOfAccessibleRepositories(project);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository create(@Nonnull RepositoryCreateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalRepository repository = this.createRepositoryInDatabase((AbstractRepositoryRequest)request, request.getProject(), request.getScmId(), null, true);
        try {
            this.createRepositoryInScm(repository);
        }
        catch (ServerException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof ProcessException) {
                log.debug("Could not create repository {}/{} [{}]", new Object[]{repository.getProject().getKey(), repository.getSlug(), repository.getId(), e});
                throw new ServerException(this.i18nService.createKeyedMessage("stash.web.repository.create.processerror", new Object[]{repository.getName(), rootCause.getClass().getSimpleName()}));
            }
            throw e;
        }
        return repository;
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional(propagation=Propagation.SUPPORTS)
    public void delete(@Nonnull Repository repository) {
        if (((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getState() != Repository.State.AVAILABLE) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("stash.service.repository.delete.invalidstate", new Object[]{repository.getProject().getKey(), repository.getSlug(), Repository.State.AVAILABLE, repository.getState()}));
        }
        final InternalRepository internal = InternalConverter.convertToInternalRepository((Repository)repository);
        final Iterable forkIds = (Iterable)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Iterable<Integer>>(){

            public Iterable<Integer> doInTransaction(TransactionStatus transactionStatus) {
                DefaultRepositoryService.this.fireRepositoryDeletionRequested((Repository)internal);
                return DefaultRepositoryService.this.deleteInDatabase(internal);
            }
        });
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                long count;
                DeleteCommandParameters.Builder builder = new DeleteCommandParameters.Builder().forkIds(forkIds);
                if (Iterables.isEmpty((Iterable)forkIds) && (count = ((Long)DefaultRepositoryService.this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Long>(){

                    public Long doInTransaction(TransactionStatus status) {
                        status.setRollbackOnly();
                        return DefaultRepositoryService.this.repositoryDao.countByHierarchy(internal.getHierarchyId());
                    }
                })).longValue()) == 0L) {
                    builder.lastInHierarchy();
                }
                DefaultRepositoryService.this.scmService.delete((Repository)internal, builder.build());
            }
        });
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<InternalRepository> findAll(@Nonnull PageRequest pageRequest) {
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return this.repositoryDao.findAll(pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#origin)")
    public Page<InternalRepository> findByOrigin(@Nonnull Repository origin, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)origin, (Object)"origin");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return this.repositoryDao.findByOrigin(InternalConverter.convertToInternalRepository((Repository)origin), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<Repository> findByOwner(@Nonnull StashUser owner, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)owner, (Object)"owner");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.findByOwner(owner.getId().intValue(), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate()));
    }

    @Nonnull
    @Secured(value="Secured using a repository accessible predicate")
    public Page<InternalRepository> findByProjectKey(@Nonnull String projectKey, @Nonnull PageRequest pageRequest) throws NoSuchProjectException {
        Preconditions.checkNotNull((Object)projectKey, (Object)"projectKey");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (this.projectService.getByKey(projectKey) == null) {
            if (InternalPersonalProject.isPersonalProjectKey((String)projectKey)) {
                return PageUtils.createEmptyPage((PageRequest)pageRequest);
            }
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("stash.service.project.notfound", new Object[]{projectKey}));
        }
        return this.repositoryDao.findByProjectKey(projectKey, pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @PreAuthorize(value="isAuthenticated() and isRepositoryAccessible(#repository)")
    public InternalRepository findPersonalFork(@Nonnull Repository repository) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        PersonalProject personalProject = this.projectService.getPersonalProject(false);
        if (personalProject == null) {
            return null;
        }
        return this.repositoryDao.findByOriginInProject(InternalConverter.convertToInternalRepository((Repository)repository), personalProject.getId().intValue());
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#repository)")
    public Page<? extends Repository> findRelated(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        return this.repositoryDao.findByHierarchy(InternalConverter.convertToInternalRepository((Repository)repository), pageRequest, this.predicateFactory.createRepositoryAccessiblePredicate());
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#request.project, 'PROJECT_ADMIN') and hasRepositoryPermission(#request.parent, 'REPO_READ')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository fork(@Nonnull RepositoryForkRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Repository parent = request.getParent();
        if (!this.isForkingEnabled()) {
            throw new ForkingDisabledException(this.i18nService.createKeyedMessage("stash.service.repository.forkingdisabled", new Object[0]), parent);
        }
        if (!this.scmService.isSupported(parent, ScmFeature.FORK)) {
            throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("stash.service.repository.scm.noforkfeature", new Object[]{parent.getProject().getKey(), parent.getSlug(), this.scmService.getScmName(parent)}), parent.getScmId(), ScmFeature.FORK);
        }
        Project project = request.getProject();
        this.checkCanForkRepository(parent, project);
        if (project == null) {
            project = this.projectService.getPersonalProject();
        }
        InternalRepository repository = this.createRepositoryInDatabase((AbstractRepositoryRequest)request, project, parent.getScmId(), parent, true);
        this.createRepositoryInScm(repository);
        return repository;
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    @Transactional(propagation=Propagation.SUPPORTS)
    public Set<NamedLink> getCloneLinks(final @Nonnull RepositoryCloneLinksRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        final StashUser user = request.isUseCurrentUser() ? this.authenticationContext.getCurrentUser() : request.getUser();
        return Chainable.chain((Iterable)this.scmService.getProtocols(request.getRepository())).filter((Predicate)new Predicate<ScmProtocol>(){

            public boolean apply(ScmProtocol protocol) {
                return request.getProtocolName() == null || request.getProtocolName().equalsIgnoreCase(protocol.getName());
            }
        }).transform((Function)new Function<ScmProtocol, NamedLink>(){

            public NamedLink apply(ScmProtocol protocol) {
                String cloneUrl = protocol.getCloneUrl(request.getRepository(), user);
                return cloneUrl == null ? null : new SimpleNamedLink(cloneUrl, protocol.getName());
            }
        }).filter(Predicates.notNull()).toSet();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public long getSize(@Nonnull Repository repository) {
        File directory = this.propertiesService.getRepositoryDir((Repository)Preconditions.checkNotNull((Object)repository));
        return directory.isDirectory() ? FileUtils.sizeOfDirectory((File)directory) : 0L;
    }

    @Unsecured(value="Allow anonymous users to check whether forking is enabled")
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean isForkingEnabled() {
        return this.featureManager.isEnabled(Feature.FORKS);
    }

    @Nonnull
    @PreAuthorize(value="hasProjectPermission(#repository.project, 'PROJECT_ADMIN')")
    @Throttled(value="scm-command")
    @Transactional
    public InternalRepository retryCreate(@Nonnull Repository repository) {
        Project project = ((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getProject();
        String projectName = ((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getName();
        String name = repository.getName();
        InternalRepository existing = this.repositoryDao.getBySlug(project.getKey(), repository.getSlug());
        if (existing == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.repository.nosuchreponame", new Object[]{name, projectName});
            throw new NoSuchEntityException(message);
        }
        if (existing.getState() == Repository.State.INITIALISATION_FAILED) {
            this.repositoryDao.delete((Object)existing);
            InternalRepository newRepository = this.createRepositoryInDatabase((AbstractRepositoryRequest)new RepositoryCreateRequest.Builder((Repository)existing).build(), project, existing.getScmId(), (Repository)existing.getOrigin(), false);
            this.createRepositoryInScm(newRepository);
            existing = newRepository;
        }
        return existing;
    }

    @Unsecured(value="Permission checks are applied while searching for repositories matching the provided criteria")
    public Page<Repository> search(@Nonnull RepositorySearchRequest request, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxRepositoriesPerPage);
        if (request.isEmpty()) {
            return PageUtils.asPageOf(Repository.class, this.findAll(pageRequest));
        }
        RepositorySearchCriteria criteria = this.createSearchCriteria(request);
        if (criteria == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        Predicate permissionPredicate = request.hasPermission() ? this.predicateFactory.createRepositoryPermissionPredicate(request.getPermission()) : (request.getVisibility() == RepositoryVisibility.PUBLIC ? Predicates.alwaysTrue() : this.predicateFactory.createRepositoryAccessiblePredicate());
        return PageUtils.asPageOf(Repository.class, (Page)this.repositoryDao.search(criteria, pageRequest, permissionPredicate));
    }

    @Value(value="${page.max.repositories}")
    public void setMaxRepositoriesPerPage(int maxRepositoriesPerPage) {
        this.maxRepositoriesPerPage = Math.max(maxRepositoriesPerPage, 50);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#request.id, 'REPO_ADMIN') and (#request.project == null or hasProjectPermission(#request.project, 'PROJECT_ADMIN'))")
    @Transactional
    public InternalRepository update(@Nonnull RepositoryUpdateRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalRepository repository = (InternalRepository)this.repositoryDao.getById((Object)request.getId());
        if (repository == null) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.repository.nosuchrepo", new Object[]{request.getId()});
            throw new NoSuchEntityException(message);
        }
        InternalRepository current = repository.copy().build();
        InternalRepository updated = current.copy().forkable(request.isForkable()).publiclyAccessible(request.isPublic()).name(request.getName()).project((InternalProject)Objects.firstNonNull((Object)InternalConverter.convertToInternalProject((Project)request.getProject()), (Object)repository.getProject())).build();
        ValidationUtils.validate((Validator)this.validator, (Object)updated, (Class[])new Class[]{Update.class});
        this.fireRepositoryModificationRequested((Repository)current, (Repository)updated);
        updated = (InternalRepository)this.repositoryDao.update((Object)updated);
        this.eventPublisher.publish((Object)new RepositoryModifiedEvent((Object)this, (Repository)current, (Repository)updated));
        return updated;
    }

    @Nonnull
    private InternalRepository createRepositoryInDatabase(AbstractRepositoryRequest request, Project project, String scmId, Repository parent, boolean cancelable) {
        String hierarchyId = parent == null ? this.generateToken() : parent.getHierarchyId();
        this.checkCanCreateRepository(project);
        InternalRepository repository = new InternalRepository.Builder().forkable(request.isForkable()).hierarchyId(hierarchyId).name(request.getName()).origin(InternalConverter.convertToInternalRepository((Repository)parent)).project(InternalConverter.convertToInternalProject((Project)project)).publiclyAccessible(request.isPublic()).scmId(scmId).build();
        ValidationUtils.validate((Validator)this.validator, (Object)repository, (Class[])new Class[]{Create.class});
        if (cancelable) {
            if (repository.isFork()) {
                this.fireRepositoryForkRequested((Repository)repository);
            } else {
                this.fireRepositoryCreationRequested((Repository)repository);
            }
        }
        return (InternalRepository)this.repositoryDao.create((Object)repository);
    }

    private void checkCanCreateRepository(Project project) {
        if (project.getType() == ProjectType.PERSONAL && !this.featureManager.isEnabled(Feature.PERSONAL_REPOS)) {
            throw new PersonalRepositoryDisabledException(this.i18nService.createKeyedMessage("stash.service.repository.create.personalrepositorydisabled", new Object[0]));
        }
    }

    private void checkCanForkRepository(Repository parent, Project project) {
        if (!parent.isForkable()) {
            throw new ForkingDisabledException(this.i18nService.createKeyedMessage("stash.service.repository.notforkable", new Object[]{parent.getProject().getKey(), parent.getSlug()}), parent);
        }
        if (!(project != null && project.getType() != ProjectType.PERSONAL || this.featureManager.isEnabled(Feature.PERSONAL_REPOS))) {
            throw new PersonalRepositoryDisabledException(this.i18nService.createKeyedMessage("stash.service.repository.fork.personalrepositorydisabled", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepositoryInScm(InternalRepository repository) {
        block5: {
            block4: {
                Repository.State state = Repository.State.INITIALISATION_FAILED;
                try {
                    this.validateCanCreateRepositoryOnDisk((Repository)repository);
                    Command command = repository.isFork() ? this.scmService.getCommandFactory((Repository)repository.getOrigin()).fork((Repository)repository) : this.scmService.getCommandFactory((Repository)repository).create();
                    command.call();
                    state = Repository.State.AVAILABLE;
                    repository = this.setRepositoryState(repository, state);
                    if (state != Repository.State.AVAILABLE) break block4;
                }
                catch (Throwable throwable) {
                    repository = this.setRepositoryState(repository, state);
                    if (state == Repository.State.AVAILABLE) {
                        this.eventPublisher.publish(repository.isFork() ? new RepositoryForkedEvent((Object)this, (Repository)repository) : new RepositoryCreatedEvent((Object)this, (Repository)repository));
                    } else {
                        this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
                    }
                    throw throwable;
                }
                this.eventPublisher.publish(repository.isFork() ? new RepositoryForkedEvent((Object)this, (Repository)repository) : new RepositoryCreatedEvent((Object)this, (Repository)repository));
                break block5;
            }
            this.eventPublisher.publish(repository.isFork() ? new RepositoryForkFailedEvent((Object)this, (Repository)repository) : new RepositoryCreationFailedEvent((Object)this, (Repository)repository));
        }
    }

    private RepositorySearchCriteria createSearchCriteria(RepositorySearchRequest request) {
        RepositorySearchCriteria criteria = new RepositorySearchCriteria().setName(request.getName()).setProjectName(request.getProjectName());
        if (request.hasVisibility()) {
            criteria.setVisibility(request.getVisibility());
            criteria.setOrder(RepositoryOrder.PROJECT_NAME);
            if (!this.featureManager.isEnabled(Feature.PUBLIC_ACCESS)) {
                if (request.getVisibility() == RepositoryVisibility.PUBLIC) {
                    return null;
                }
                if (request.getVisibility() == RepositoryVisibility.PRIVATE) {
                    criteria.setVisibility(null);
                }
            }
        } else {
            criteria.setOrder(RepositoryOrder.REPO_NAME);
        }
        return criteria;
    }

    private Iterable<Integer> deleteInDatabase(InternalRepository repository) {
        Iterable forkIds = this.repositoryDao.getForkIds(repository);
        if (!Iterables.isEmpty((Iterable)forkIds)) {
            this.repositoryDao.updateOrigin(repository, repository.getOrigin());
        }
        this.repositoryDao.deleteById((Object)repository.getId());
        this.fireRepositoryDeleted(repository);
        return forkIds;
    }

    private void fireRepositoryCreationRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryCreationRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.repository.creationcanceled", new Object[0]);
            throw new RepositoryCreationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryDeleted(InternalRepository repository) {
        this.eventPublisher.publish((Object)new RepositoryDeletedEvent((Object)this, (Repository)repository));
    }

    private void fireRepositoryDeletionRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryDeletionRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.repository.deletioncanceled", new Object[0]);
            throw new RepositoryDeletionCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryForkRequested(Repository repository) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryForkRequestedEvent((Object)this, repository, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.repository.forkcanceled", new Object[0]);
            throw new RepositoryForkCanceledException(message, cancelState.getCancelMessages());
        }
    }

    private void fireRepositoryModificationRequested(Repository current, Repository updated) {
        SimpleCancelState cancelState = new SimpleCancelState();
        this.eventPublisher.publish((Object)new RepositoryModificationRequestedEvent((Object)this, current, updated, (CancelState)cancelState));
        if (cancelState.isCanceled()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("stash.service.repository.updatecanceled", new Object[0]);
            throw new RepositoryModificationCanceledException(message, cancelState.getCancelMessages());
        }
    }

    @Nonnull
    private String generateToken() {
        String token = this.tokenGenerator.generateToken();
        if (token.length() > 20) {
            token = token.substring(0, 20);
        }
        return token;
    }

    private InternalRepository setRepositoryState(InternalRepository repository, Repository.State state) {
        return (InternalRepository)this.repositoryDao.update((Object)repository.copy().state(state).build());
    }

    private void validateCanCreateRepositoryOnDisk(Repository repository) {
        File repositoryRoot = this.propertiesService.getRepositoryDir(repository);
        if (repositoryRoot.isFile()) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("stash.service.repository.createfailed.filepresent", new Object[]{repository.getName(), repositoryRoot}));
        }
        if (repositoryRoot.isDirectory()) {
            throw new IllegalRepositoryStateException(this.i18nService.createKeyedMessage("stash.service.repository.createfailed.directorypresent", new Object[]{repository.getName(), repositoryRoot}));
        }
    }
}

