/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.migration;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.stash.Product;
import com.atlassian.stash.event.migration.MigrationCanceledEvent;
import com.atlassian.stash.event.migration.MigrationFailedEvent;
import com.atlassian.stash.event.migration.MigrationStartedEvent;
import com.atlassian.stash.event.migration.MigrationSucceededEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.db.DbType;
import com.atlassian.stash.internal.maintenance.MaintenanceEvent;
import com.atlassian.stash.internal.maintenance.MaintenanceModePhase;
import com.atlassian.stash.internal.maintenance.MaintenanceTask;
import com.atlassian.stash.internal.maintenance.MaintenanceTaskFactory;
import com.atlassian.stash.internal.maintenance.MaintenanceType;
import com.atlassian.stash.internal.maintenance.TaskMaintenanceEvent;
import com.atlassian.stash.internal.maintenance.migration.BaseMigrationTask;
import com.atlassian.stash.internal.maintenance.migration.MigrationState;
import com.atlassian.stash.internal.migration.CanceledMigrationException;
import com.atlassian.stash.internal.migration.MigrationException;
import com.google.common.base.Throwables;

public class DatabaseMigrationTask
extends BaseMigrationTask {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;

    public DatabaseMigrationTask(DatabaseManager databaseManager, EventPublisher eventPublisher, MaintenanceTaskFactory factory, I18nService i18nService, DatabaseHandle targetDatabase) {
        super(databaseManager, factory, i18nService, targetDatabase);
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
    }

    @Override
    public void run() {
        MigrationException exception = null;
        try {
            this.eventPublisher.publish((Object)new MigrationStartedEvent((Object)this));
            super.run();
        }
        catch (RuntimeException e) {
            try {
                exception = this.convertException(e);
                throw exception;
            }
            catch (Throwable throwable) {
                this.publishMigrationEvent(exception);
                throw throwable;
            }
        }
        this.publishMigrationEvent(exception);
    }

    @Override
    protected MaintenanceTask createMigrationTask(MaintenanceTaskFactory factory, MigrationState state) {
        TaskMaintenanceEvent event = new TaskMaintenanceEvent(EventType.get((String)"database-unavailable"), Product.NAME + " is unavailable while its data is migrated to a new database", EventLevel.get((String)"maintenance"), MaintenanceType.MIGRATION);
        return ((MaintenanceModePhase.Builder)factory.maintenanceModePhaseBuilder().event((MaintenanceEvent)event).add(super.createMigrationTask(factory, state), 100)).build();
    }

    protected void publishMigrationEvent(MigrationException exception) {
        if (exception instanceof CanceledMigrationException) {
            this.eventPublisher.publish((Object)new MigrationCanceledEvent((Object)this));
        } else if (exception != null) {
            this.eventPublisher.publish((Object)new MigrationFailedEvent((Object)this));
        } else {
            this.eventPublisher.publish((Object)new MigrationSucceededEvent((Object)this));
        }
    }

    private MigrationException convertException(RuntimeException e) {
        if (e instanceof MigrationException) {
            return (MigrationException)e;
        }
        Throwable cause = Throwables.getRootCause((Throwable)e);
        if (cause != null && cause.getMessage() != null && cause.getMessage().contains("invalid byte sequence for encoding \"UTF8\": 0x00") && DbType.POSTGRES.getDriverClassName().equals(this.state.getTargetDatabase().getConfiguration().getDriverClassName())) {
            return new MigrationException(this.i18nService.createKeyedMessage("stash.migration.failed.nullcharacters.postgres", new Object[]{Product.NAME, "https://confluence.atlassian.com/x/OwOCKQ"}), (Throwable)e);
        }
        return new MigrationException(this.i18nService.createKeyedMessage("stash.migration.failed", new Object[]{Product.NAME}), (Throwable)e);
    }
}

