/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance.backup;

import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.backup.BackupException;
import com.atlassian.stash.internal.maintenance.CompositeMaintenanceTask;
import com.atlassian.stash.internal.maintenance.backup.BackupState;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.google.common.io.Closeables;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupPhase
extends CompositeMaintenanceTask {
    public static final TimeZone TIMEZONE_FOR_TIMESTAMP = TimeZone.getTimeZone("UTC");
    public static final String FORMAT_UTC_TIMESTAMP = "yyyyMMdd-HHmmss-SSS'Z'";
    private static final Logger log = LoggerFactory.getLogger(BackupPhase.class);
    private final StashAuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final ApplicationSettings settings;
    private final BackupState state;

    protected BackupPhase(StashAuthenticationContext authenticationContext, I18nService i18nService, ApplicationSettings settings, BackupState state, CompositeMaintenanceTask.Step[] steps, int totalWeight) {
        super(steps, totalWeight);
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.settings = settings;
        this.state = state;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        File backupFile;
        boolean success;
        block14: {
            success = false;
            if (!this.settings.getBackupDir().canWrite()) {
                throw new BackupException(this.i18nService.createKeyedMessage("stash.backup.cant.write", new Object[]{this.settings.getBackupDir()}));
            }
            backupFile = new File(this.settings.getBackupDir(), this.getBackupFilename());
            CloseShieldZipOutputStream zipStream = null;
            try {
                log.debug("Writing backup to {}", (Object)backupFile.getAbsolutePath());
                FileOutputStream fileStream = new FileOutputStream(backupFile);
                zipStream = new CloseShieldZipOutputStream(fileStream);
                this.state.setBackupFile(backupFile);
                this.state.setBackupZipStream(zipStream);
                super.run();
                success = true;
                if (zipStream == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new BackupException(this.i18nService.createKeyedMessage("stash.backup.create.failed", new Object[0]), (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (zipStream != null) {
                        try {
                            zipStream.reallyClose();
                        }
                        catch (IOException e2) {
                            log.debug("Problem closing the backup zip", (Throwable)e2);
                        }
                    }
                    if (success) {
                        if (!this.isCanceled()) throw throwable;
                    }
                    if (backupFile.delete()) {
                        log.debug("Deleted partial backup file at {} after catching an exception", (Object)backupFile.getAbsolutePath());
                        throw throwable;
                    }
                    log.debug("Failed to delete partial backup file at {}; the file has been marked for deletion on exit", (Object)backupFile.getAbsolutePath());
                    backupFile.deleteOnExit();
                    throw throwable;
                }
            }
            try {
                zipStream.reallyClose();
            }
            catch (IOException e) {
                log.debug("Problem closing the backup zip", (Throwable)e);
            }
        }
        if (success) {
            if (!this.isCanceled()) return;
        }
        if (backupFile.delete()) {
            log.debug("Deleted partial backup file at {} after catching an exception", (Object)backupFile.getAbsolutePath());
            return;
        }
        log.debug("Failed to delete partial backup file at {}; the file has been marked for deletion on exit", (Object)backupFile.getAbsolutePath());
        backupFile.deleteOnExit();
    }

    private String getBackupFilename() {
        StashUser currentUser = this.authenticationContext.getCurrentUser();
        String username = currentUser == null ? "anonymous" : currentUser.getName();
        username = username.replaceAll("[^a-zA-Z0-9-_]", "_");
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_UTC_TIMESTAMP);
        format.setTimeZone(TIMEZONE_FOR_TIMESTAMP);
        String displayTimestamp = format.format(new Date());
        return String.format("%s-%s-%s.zip", "backup", username, displayTimestamp);
    }

    static class CloseShieldZipOutputStream
    extends ZipOutputStream {
        public CloseShieldZipOutputStream(FileOutputStream fileStream) {
            super((OutputStream)fileStream);
        }

        public void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reallyClose() throws IOException {
            try {
                super.close();
            }
            finally {
                Closeables.closeQuietly((Closeable)this.delegate);
            }
        }
    }

    public static class Builder
    extends CompositeMaintenanceTask.AbstractBuilder<Builder> {
        private final BackupState state;
        private final I18nService i18nService;
        private final ApplicationSettings settings;
        private final StashAuthenticationContext authenticationContext;

        public Builder(StashAuthenticationContext authenticationContext, I18nService i18nService, ApplicationSettings settings, BackupState state) {
            this.authenticationContext = authenticationContext;
            this.i18nService = i18nService;
            this.settings = settings;
            this.state = state;
        }

        @Override
        @Nonnull
        public BackupPhase build() {
            return new BackupPhase(this.authenticationContext, this.i18nService, this.settings, this.state, this.steps.toArray(new CompositeMaintenanceTask.Step[this.steps.size()]), this.totalWeight);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

