/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.maintenance;

import com.atlassian.stash.internal.maintenance.MaintenanceEvent;
import com.atlassian.stash.internal.maintenance.MaintenanceModeHelper;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class HazelcastMaintenanceModeHelper
implements MaintenanceModeHelper,
ItemListener<MaintenanceEvent> {
    private final Object lock = new Object();
    private final MaintenanceModeHelper localMaintenanceModeHelper;
    private final ISet<MaintenanceEvent> maintenanceEvents;
    private String listenerRegistrationId;

    public HazelcastMaintenanceModeHelper(ISet<MaintenanceEvent> maintenanceEvents, MaintenanceModeHelper localMaintenanceModeHelper) {
        this.localMaintenanceModeHelper = localMaintenanceModeHelper;
        this.maintenanceEvents = maintenanceEvents;
    }

    @PreDestroy
    public void destroy() {
        if (this.listenerRegistrationId != null) {
            this.maintenanceEvents.removeItemListener(this.listenerRegistrationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            this.listenerRegistrationId = this.maintenanceEvents.addItemListener((ItemListener)this, true);
            for (MaintenanceEvent event : this.maintenanceEvents) {
                this.localMaintenanceModeHelper.lock(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemAdded(ItemEvent<MaintenanceEvent> item) {
        Object object = this.lock;
        synchronized (object) {
            this.localMaintenanceModeHelper.lock((MaintenanceEvent)item.getItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemRemoved(ItemEvent<MaintenanceEvent> item) {
        Object object = this.lock;
        synchronized (object) {
            this.localMaintenanceModeHelper.unlock((MaintenanceEvent)item.getItem());
        }
    }

    @Override
    public void lock(@Nonnull MaintenanceEvent event) {
        this.maintenanceEvents.add((Object)event);
    }

    @Override
    public void unlock(@Nonnull MaintenanceEvent event) {
        this.maintenanceEvents.remove((Object)event);
    }
}

