/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.concurrent.BucketProcessor;
import com.atlassian.stash.concurrent.BucketedExecutor;
import com.atlassian.stash.concurrent.BucketedExecutorSettings;
import com.atlassian.stash.concurrent.ConcurrencyPolicy;
import com.atlassian.stash.concurrent.ConcurrencyService;
import com.atlassian.stash.event.RepositoryRefsChangedEvent;
import com.atlassian.stash.internal.idx.HierarchyIndexer;
import com.atlassian.stash.internal.idx.HierarchyIndexingRequest;
import com.atlassian.stash.repository.Repository;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CommitIndexingScheduler {
    private static final Logger log = LoggerFactory.getLogger(CommitIndexingScheduler.class);
    private final BucketedExecutor<HierarchyIndexingRequest> executor;

    @Autowired
    public CommitIndexingScheduler(ConcurrencyService concurrencyService, HierarchyIndexer hierarchyIndexer, @Value(value="${indexing.max.threads}") int maxConcurrency) {
        this.executor = concurrencyService.getBucketedExecutor("commit-indexing", new BucketedExecutorSettings.Builder(HierarchyIndexingRequest.BUCKET_EXTRACTOR, (BucketProcessor)hierarchyIndexer).maxConcurrency(maxConcurrency, ConcurrencyPolicy.PER_NODE).build());
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        Repository repository = event.getRepository();
        if (event.getRefChanges().isEmpty()) {
            log.debug("{}: Skipping indexing; no refs were changed (Remotely-merged pull request?)", (Object)repository);
        } else {
            this.executor.submit((Serializable)new HierarchyIndexingRequest(repository));
        }
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdown();
    }
}

