/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.stash.hook.repository.RepositoryMergeRequestCheck;
import com.atlassian.stash.hook.repository.RepositoryMergeRequestCheckContext;
import com.atlassian.stash.internal.hook.repository.DefaultRepositoryMergeRequestCheckContext;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.RepositoryHookSettingsCallback;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.pull.MergeRequest;
import com.atlassian.stash.scm.pull.MergeRequestCheck;
import com.atlassian.stash.setting.Settings;
import com.atlassian.stash.util.Timer;
import com.atlassian.stash.util.TimerUtils;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryMergeRequestCheckAdapter
implements MergeRequestCheck {
    private static final Logger log = LoggerFactory.getLogger(RepositoryMergeRequestCheckAdapter.class);
    private final InternalRepositoryHookService hookService;

    public RepositoryMergeRequestCheckAdapter(InternalRepositoryHookService hookService) {
        this.hookService = hookService;
    }

    public void check(final @Nonnull MergeRequest request) {
        Repository repository = request.getPullRequest().getToRef().getRepository();
        this.hookService.visitEnabledHooks(repository, RepositoryMergeRequestCheck.class, (RepositoryHookSettingsCallback)new RepositoryHookSettingsCallback<RepositoryMergeRequestCheck>(){

            public boolean visit(@Nonnull String key, RepositoryMergeRequestCheck hook, Settings settings) {
                try (Timer timer = TimerUtils.start((String)(key + "#check"));){
                    hook.check((RepositoryMergeRequestCheckContext)new DefaultRepositoryMergeRequestCheckContext(request, settings));
                }
                catch (Exception e) {
                    log.warn("Merge Check {} failed.", (Object)key, (Object)e);
                }
                return true;
            }
        });
    }
}

