/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.avatar.CacheableAvatarSupplier;
import com.atlassian.stash.avatar.DelegatingCacheableAvatarSupplier;
import com.atlassian.stash.avatar.SimpleAvatarSupplier;
import com.atlassian.stash.event.hook.RepositoryHookDisabledEvent;
import com.atlassian.stash.event.hook.RepositoryHookEnabledEvent;
import com.atlassian.stash.event.hook.RepositoryHookSettingsChangedEvent;
import com.atlassian.stash.exception.FormValidationException;
import com.atlassian.stash.exception.IllegalEntityStateException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.hook.repository.RepositoryHook;
import com.atlassian.stash.hook.repository.RepositoryHookDetails;
import com.atlassian.stash.hook.repository.RepositoryHookImplementor;
import com.atlassian.stash.hook.repository.RepositoryHookService;
import com.atlassian.stash.hook.repository.RepositoryHookType;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.hook.repository.EmptyHookSettings;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.RepositoryHookSettingsCallback;
import com.atlassian.stash.internal.hook.repository.SimpleRepositoryHook;
import com.atlassian.stash.internal.hook.repository.SimpleRepositoryHookDetails;
import com.atlassian.stash.internal.plugin.RepositoryHookModuleDescriptor;
import com.atlassian.stash.internal.plugin.ValidatorModuleDescriptor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.InternalRepositoryHook;
import com.atlassian.stash.internal.repository.RepositoryHookDao;
import com.atlassian.stash.internal.setting.InternalSharedLob;
import com.atlassian.stash.internal.setting.MapSettingsBuilder;
import com.atlassian.stash.internal.setting.SettingsHelper;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.setting.RepositorySettingsValidator;
import com.atlassian.stash.setting.Settings;
import com.atlassian.stash.setting.SettingsBuilder;
import com.atlassian.stash.setting.SettingsValidationErrors;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.validation.FormErrors;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

@AvailableToPlugins(value=RepositoryHookService.class)
@Service
public class DefaultRepositoryHookService
extends AbstractService
implements InternalRepositoryHookService {
    static final int PAGE_SETTINGS_LIMIT = 20;
    private static final Logger log = LoggerFactory.getLogger(DefaultRepositoryHookService.class);
    private static final String HOOK_DEFAULT_ICON = "/hooks/icon-default-hook.png";
    private static final Comparator<SimpleRepositoryHookDetails> HOOK_NAME_COMPARATOR = new Comparator<SimpleRepositoryHookDetails>(){

        @Override
        public int compare(SimpleRepositoryHookDetails details1, SimpleRepositoryHookDetails details2) {
            return details1.getName().compareTo(details2.getName());
        }
    };
    private static final Function<ModuleDescriptor<?>, String> TO_COMPLETE_KEY = new Function<ModuleDescriptor<?>, String>(){

        public String apply(ModuleDescriptor<?> hook) {
            return hook.getCompleteKey();
        }
    };
    private static final Function<RepositoryHookDetails, String> DETAILS_TO_KEY = new Function<RepositoryHookDetails, String>(){

        public String apply(RepositoryHookDetails details) {
            return details.getKey();
        }
    };
    private static final Function<InternalRepositoryHook, String> HOOK_TO_KEY = new Function<InternalRepositoryHook, String>(){

        public String apply(InternalRepositoryHook details) {
            return details.getHookKey();
        }
    };
    private final EventPublisher eventPublisher;
    private final FileNameMap fileNameMap;
    private final RepositoryHookDao hookDao;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private final SettingsHelper settingsHelper;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public DefaultRepositoryHookService(EventPublisher eventPublisher, FileNameMap fileNameMap, RepositoryHookDao hookDao, I18nService i18nService, PluginAccessor pluginAccessor, SettingsHelper settingsHelper, PlatformTransactionManager transactionManager) {
        this.eventPublisher = eventPublisher;
        this.fileNameMap = fileNameMap;
        this.hookDao = hookDao;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.settingsHelper = settingsHelper;
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(4);
    }

    @Nonnull
    @Unsecured(value="No private data is exposed by this method")
    @Transactional(propagation=Propagation.SUPPORTS)
    public SettingsBuilder createSettingsBuilder() {
        return new MapSettingsBuilder();
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook disable(@Nonnull Repository repository, @Nonnull String hookKey) {
        InternalRepository internalRepository = InternalConverter.convertToInternalRepository((Repository)repository);
        RepositoryHook repositoryHook = this.setEnabled(internalRepository, hookKey, null, false);
        this.eventPublisher.publish((Object)new RepositoryHookDisabledEvent((Object)this, (Repository)internalRepository, hookKey));
        return repositoryHook;
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook enable(@Nonnull Repository repository, @Nonnull String hookKey) {
        return this.enableAndPublishEvent(InternalConverter.convertToInternalRepository((Repository)repository), hookKey, null);
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook enable(@Nonnull Repository repository, @Nonnull String hookKey, @Nonnull Settings settings) throws FormValidationException {
        Preconditions.checkNotNull((Object)settings, (Object)"settings");
        this.validateSettings(repository, hookKey, settings);
        RepositoryHook repositoryHook = this.enableAndPublishEvent(InternalConverter.convertToInternalRepository((Repository)repository), hookKey, settings);
        this.eventPublisher.publish((Object)new RepositoryHookSettingsChangedEvent((Object)this, repository, hookKey, settings));
        return repositoryHook;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<RepositoryHook> findAll(@Nonnull Repository repository, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return this.getRepositoryHookPage(repository, pageRequest, this.getAllOrdered());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Page<RepositoryHook> findByType(@Nonnull Repository repository, @Nonnull RepositoryHookType type, @Nonnull PageRequest pageRequest) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest");
        return this.getRepositoryHookPage(repository, pageRequest, this.getOrderedByType(type));
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('LICENSED_USER')")
    public CacheableAvatarSupplier getAvatar(@Nonnull String hookKey) {
        SimpleRepositoryHookDetails details = this.getHookDetailsOrFail(hookKey);
        if (details.getIconPath() == null) {
            return this.getDefaultAvatar();
        }
        try {
            Plugin plugin = this.pluginAccessor.getEnabledPluginModule(hookKey).getPlugin();
            URL resource = plugin.getResource(details.getIconPath());
            if (resource != null) {
                return this.getCacheableSupplier((Resource)new UrlResource(resource));
            }
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.warn("Error loading icon for {}", (Object)hookKey, (Object)e);
            }
            log.warn("Error loading icon for {}: {}", (Object)hookKey, (Object)e.getMessage());
        }
        return this.getDefaultAvatar();
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public RepositoryHook getByKey(@Nonnull Repository repository, @Nonnull String hookKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(hookKey);
        if (!(moduleDescriptor instanceof RepositoryHookModuleDescriptor)) {
            return null;
        }
        SimpleRepositoryHookDetails descriptor = (SimpleRepositoryHookDetails)SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR.apply((Object)((RepositoryHookModuleDescriptor)moduleDescriptor));
        InternalRepositoryHook hook = this.hookDao.findByKey(InternalConverter.convertToInternalRepository((Repository)repository), hookKey);
        return new SimpleRepositoryHook(descriptor, hook != null && hook.isEnabled(), hook != null && hook.hasSettings());
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Settings getSettings(@Nonnull Repository repository, @Nonnull String hookKey) {
        InternalRepositoryHook hook = this.hookDao.findByKey(InternalConverter.convertToInternalRepository((Repository)repository), hookKey);
        return hook == null || hook.getSettings() == null ? null : this.settingsHelper.deserialize(hook.getSettings().getData());
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    public Settings setSettings(@Nonnull Repository repository, @Nonnull String hookKey, @Nonnull Settings settings) throws FormValidationException {
        Preconditions.checkNotNull((Object)settings, (Object)"settings");
        this.validateSettings(repository, hookKey, settings);
        InternalRepositoryHook repositoryHook = this.hookDao.findByKey(InternalConverter.convertToInternalRepository((Repository)repository), hookKey);
        if (repositoryHook == null) {
            this.createHook(hookKey, repository, false, settings);
        } else {
            this.updateHook(repositoryHook, repositoryHook.isEnabled(), settings);
        }
        this.eventPublisher.publish((Object)new RepositoryHookSettingsChangedEvent((Object)this, repository, hookKey, settings));
        return settings;
    }

    @Unsecured(value="This method is internal-only, so it needs no permission checks")
    public <T extends RepositoryHookImplementor> boolean visitEnabledHooks(@Nonnull Repository repository, @Nonnull Class<T> type, @Nonnull RepositoryHookSettingsCallback<T> callback) {
        Preconditions.checkNotNull((Object)repository, (Object)"repository");
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(callback, (Object)"callback");
        Map<String, RepositoryHookModuleDescriptor> modulesByHookKey = this.buildDescriptorIndex(type);
        if (!modulesByHookKey.isEmpty()) {
            for (List keys : Iterables.partition(modulesByHookKey.keySet(), (int)20)) {
                List enabledHooks = this.hookDao.findEnabledByKey(InternalConverter.convertToInternalRepository((Repository)repository), (Collection)keys);
                if (((Boolean)this.transactionTemplate.execute((TransactionCallback)new RepositoryHookPagedTransactionCallback(callback, enabledHooks, modulesByHookKey))).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private static <T> Predicate<RepositoryHookModuleDescriptor> isModuleOfType(final Class<T> type) {
        return new Predicate<RepositoryHookModuleDescriptor>(){

            public boolean apply(RepositoryHookModuleDescriptor input) {
                return type.isAssignableFrom(input.getModuleClass());
            }
        };
    }

    private static Predicate<RepositoryHookModuleDescriptor> isModuleOfType(final RepositoryHookType type) {
        return new Predicate<RepositoryHookModuleDescriptor>(){

            public boolean apply(RepositoryHookModuleDescriptor descriptor) {
                return type.equals((Object)descriptor.getType());
            }
        };
    }

    private <T extends RepositoryHookImplementor> Map<String, RepositoryHookModuleDescriptor> buildDescriptorIndex(Class<T> type) {
        return Maps.uniqueIndex((Iterable)Iterables.filter(this.getDescriptors(), DefaultRepositoryHookService.isModuleOfType(type)), TO_COMPLETE_KEY);
    }

    private void createHook(String hookKey, Repository repository, boolean enabled, Settings settings) {
        InternalRepositoryHook.Builder hookBuilder = new InternalRepositoryHook.Builder().hookKey(hookKey).repository(InternalConverter.convertToInternalRepository((Repository)repository)).enabled(enabled);
        if (settings != null) {
            hookBuilder.settings(this.toLob(settings));
        }
        this.hookDao.create((Object)hookBuilder.build());
    }

    private RepositoryHook enableAndPublishEvent(InternalRepository internalRepository, String hookKey, Settings settings) {
        RepositoryHook repositoryHook = this.setEnabled(internalRepository, hookKey, settings, true);
        this.eventPublisher.publish((Object)new RepositoryHookEnabledEvent((Object)this, (Repository)internalRepository, hookKey));
        return repositoryHook;
    }

    private List<SimpleRepositoryHookDetails> getAllOrdered() {
        return this.getOrdered(Iterables.transform(this.getDescriptors(), SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR));
    }

    private Iterable<SimpleRepositoryHookDetails> getByType(RepositoryHookType type) {
        return Iterables.transform((Iterable)Iterables.filter(this.getDescriptors(), DefaultRepositoryHookService.isModuleOfType(type)), SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR);
    }

    private CacheableAvatarSupplier getCacheableSupplier(Resource resource) throws IOException {
        return new DelegatingCacheableAvatarSupplier((AvatarSupplier)new SimpleAvatarSupplier(this.fileNameMap.getContentTypeFor(resource.getFilename()), resource.getInputStream()), resource.lastModified());
    }

    private CacheableAvatarSupplier getDefaultAvatar() {
        try {
            return this.getCacheableSupplier((Resource)new UrlResource(this.getClass().getResource(HOOK_DEFAULT_ICON)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Iterable<RepositoryHookModuleDescriptor> getDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(RepositoryHookModuleDescriptor.class);
    }

    private SimpleRepositoryHookDetails getHookDetailsOrFail(String hookKey) {
        return (SimpleRepositoryHookDetails)SimpleRepositoryHookDetails.FROM_MODULE_DESCRIPTOR.apply((Object)this.getModuleDescriptorOrFail(hookKey));
    }

    private Set<String> getHookKeys(List<SimpleRepositoryHookDetails> hookDetails) {
        return Maps.uniqueIndex(hookDetails, DETAILS_TO_KEY).keySet();
    }

    private Map<String, InternalRepositoryHook> getHooksForRepository(InternalRepository repository, Set<String> hookKeys) {
        return Maps.uniqueIndex((Iterable)this.hookDao.findEnabledByKey(repository, hookKeys), HOOK_TO_KEY);
    }

    private RepositoryHookModuleDescriptor getModuleDescriptorOrFail(String hookKey) {
        ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(hookKey);
        if (!(moduleDescriptor instanceof RepositoryHookModuleDescriptor)) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("stash.service.repository.hook.nosuchhook", new Object[]{hookKey}));
        }
        return (RepositoryHookModuleDescriptor)moduleDescriptor;
    }

    private List<SimpleRepositoryHookDetails> getOrdered(Iterable<SimpleRepositoryHookDetails> hooks) {
        ArrayList hooksAsList = Lists.newArrayList(hooks);
        Collections.sort(hooksAsList, HOOK_NAME_COMPARATOR);
        return hooksAsList;
    }

    private List<SimpleRepositoryHookDetails> getOrderedByType(RepositoryHookType type) {
        return this.getOrdered(this.getByType(type));
    }

    private Page<RepositoryHook> getRepositoryHookPage(Repository repository, PageRequest pageRequest, List<SimpleRepositoryHookDetails> hookDetails) {
        if (pageRequest.getStart() > hookDetails.size() || hookDetails.isEmpty()) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        final Map<String, InternalRepositoryHook> hooksByKey = this.getHooksForRepository(InternalConverter.convertToInternalRepository((Repository)repository), this.getHookKeys(hookDetails));
        Page hookPage = PageUtils.createPage(hookDetails.subList(pageRequest.getStart(), hookDetails.size()), (PageRequest)pageRequest);
        return hookPage.transform((Function)new Function<SimpleRepositoryHookDetails, RepositoryHook>(){

            public RepositoryHook apply(SimpleRepositoryHookDetails details) {
                InternalRepositoryHook repositoryHook = (InternalRepositoryHook)hooksByKey.get(details.getKey());
                boolean isEnabled = false;
                boolean hasSettings = false;
                if (repositoryHook != null) {
                    isEnabled = repositoryHook.isEnabled();
                    hasSettings = repositoryHook.hasSettings();
                }
                return new SimpleRepositoryHook(details, isEnabled, hasSettings);
            }
        });
    }

    private boolean requiresSettings(SimpleRepositoryHookDetails hookDetails) {
        return StringUtils.isNotBlank((String)hookDetails.getConfigFormKey());
    }

    private RepositoryHook setEnabled(InternalRepository internalRepository, String hookKey, Settings settings, boolean enabling) {
        boolean hasSettings;
        Preconditions.checkNotNull((Object)internalRepository, (Object)"repository");
        Preconditions.checkNotNull((Object)hookKey, (Object)"hookKey");
        SimpleRepositoryHookDetails hookDetails = this.getHookDetailsOrFail(hookKey);
        InternalRepositoryHook hook = this.hookDao.findByKey(internalRepository, hookKey);
        boolean bl = hasSettings = hook != null && hook.getSettings() != null || settings != null;
        if (enabling && this.requiresSettings(hookDetails) && !hasSettings) {
            throw new IllegalEntityStateException(this.i18nService.createKeyedMessage("stash.service.hook.notconfigured", new Object[]{hookKey}));
        }
        if (hook == null) {
            this.createHook(hookKey, (Repository)internalRepository, enabling, settings);
        } else if (this.shouldUpdateHook(hook, settings, enabling)) {
            this.updateHook(hook, enabling, settings);
        }
        return new SimpleRepositoryHook(hookDetails, enabling, hasSettings);
    }

    private boolean shouldUpdateHook(InternalRepositoryHook hook, Settings settings, boolean enabling) {
        return hook.isEnabled() != enabling || settings != null;
    }

    private InternalSharedLob toLob(Settings settings) {
        return new InternalSharedLob.Builder().data(this.settingsHelper.serialize(settings)).build();
    }

    private void updateHook(InternalRepositoryHook hook, boolean enabled, Settings settings) {
        InternalRepositoryHook.Builder hookBuilder = new InternalRepositoryHook.Builder(hook).enabled(enabled);
        if (settings != null) {
            hookBuilder.settings(this.toLob(settings));
        }
        this.hookDao.update((Object)hookBuilder.build());
    }

    private void validateSettings(Repository repository, String hookKey, Settings settings) throws FormValidationException {
        ModuleDescriptor pluginModule = this.pluginAccessor.getEnabledPluginModule(hookKey);
        Preconditions.checkArgument((boolean)ValidatorModuleDescriptor.class.isInstance(pluginModule), (Object)("Module '" + hookKey + "' does not implement " + ValidatorModuleDescriptor.class.getName()));
        RepositorySettingsValidator validator = ((ValidatorModuleDescriptor)pluginModule).getValidator();
        if (validator != null) {
            SimpleSettingsValidationErrors validationErrors = new SimpleSettingsValidationErrors((Errors)new SettingsErrors(settings));
            validator.validate(settings, (SettingsValidationErrors)validationErrors, repository);
            if (!validationErrors.isEmpty()) {
                throw new FormValidationException(this.i18nService.createKeyedMessage("stash.repository.setting.validation.error", new Object[0]), (FormErrors)validationErrors);
            }
        }
    }

    private class RepositoryHookPagedTransactionCallback
    implements TransactionCallback<Boolean> {
        private final List<InternalRepositoryHook> repositoryHooks;
        private final Map<String, RepositoryHookModuleDescriptor> enabledHooks;
        private RepositoryHookSettingsCallback callback;

        private RepositoryHookPagedTransactionCallback(@Nonnull RepositoryHookSettingsCallback callback, @Nonnull List<InternalRepositoryHook> repositoryHooks, Map<String, RepositoryHookModuleDescriptor> enabledHooks) {
            Preconditions.checkNotNull((Object)callback);
            Preconditions.checkNotNull(repositoryHooks);
            Preconditions.checkNotNull(enabledHooks);
            this.callback = callback;
            this.repositoryHooks = repositoryHooks;
            this.enabledHooks = enabledHooks;
        }

        public Boolean doInTransaction(TransactionStatus txStatus) {
            for (InternalRepositoryHook repositoryHook : this.repositoryHooks) {
                String hookKey = repositoryHook.getHookKey();
                Settings settings = (Settings)Objects.firstNonNull((Object)this.toSettings(repositoryHook.getSettings()), (Object)EmptyHookSettings.INSTANCE);
                if (this.callback.visit(hookKey, this.enabledHooks.get(hookKey).getModule(), settings)) continue;
                return false;
            }
            return true;
        }

        private Settings toSettings(InternalSharedLob settingsLob) {
            return settingsLob == null ? null : DefaultRepositoryHookService.this.settingsHelper.deserialize(settingsLob.getData());
        }
    }

    private static class SimpleSettingsValidationErrors
    implements SettingsValidationErrors,
    FormErrors {
        private final Errors errors;

        private SimpleSettingsValidationErrors(Errors errors) {
            this.errors = errors;
        }

        public void addFieldError(String fieldName, String errorMessage) {
            this.errors.rejectValue(fieldName, errorMessage, errorMessage);
        }

        public void addFormError(String errorMessage) {
            this.errors.reject(errorMessage, errorMessage);
        }

        @Nonnull
        public Collection<String> getErrors(@Nonnull String field) {
            return Collections2.transform((Collection)this.errors.getFieldErrors(field), (Function)new Function<FieldError, String>(){

                public String apply(FieldError input) {
                    return input.getDefaultMessage();
                }
            });
        }

        @Nonnull
        public Map<String, Collection<String>> getFieldErrors() {
            HashMultimap errorMap = HashMultimap.create();
            for (FieldError message : this.errors.getFieldErrors()) {
                errorMap.put((Object)message.getField(), (Object)message.getDefaultMessage());
            }
            return errorMap.asMap();
        }

        @Nonnull
        public Collection<String> getFormErrors() {
            return Collections2.transform((Collection)this.errors.getGlobalErrors(), (Function)new Function<ObjectError, String>(){

                public String apply(ObjectError input) {
                    return input.getDefaultMessage();
                }
            });
        }

        public boolean isEmpty() {
            return !this.errors.hasErrors();
        }
    }

    private static class SettingsErrors
    extends AbstractBindingResult {
        private final Settings settings;

        public SettingsErrors(Settings settings) {
            super("__OBJECT__");
            this.settings = settings;
        }

        public Object getTarget() {
            return this.settings;
        }

        protected Object getActualFieldValue(String field) {
            return this.settings.asMap().get(field);
        }
    }
}

