/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.stash.hook.HookRequestHandle;
import com.atlassian.stash.hook.HookService;
import com.atlassian.stash.hook.HookUtils;
import com.atlassian.stash.internal.process.ExternalProcessConfigurer;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessImpl;
import com.atlassian.utils.process.ExternalProcessSettings;
import com.atlassian.utils.process.ProcessMonitor;
import java.io.File;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HookExternalProcessConfigurer
implements ExternalProcessConfigurer {
    private static final Logger log = LoggerFactory.getLogger(HookExternalProcessConfigurer.class);
    private final HookService hookService;
    private final File repositoriesDir;

    @Autowired
    public HookExternalProcessConfigurer(ApplicationPropertiesService propertiesService, HookService hookService) {
        this.hookService = hookService;
        this.repositoriesDir = propertiesService.getRepositoriesDir();
    }

    public void configure(@Nonnull ExternalProcessImpl process, @Nonnull ExternalProcessSettings settings) {
        File workingDirectory = settings.getWorkingDirectory();
        if (workingDirectory != null && this.repositoriesDir.equals(workingDirectory.getParentFile())) {
            int repositoryId;
            try {
                repositoryId = Integer.parseInt(workingDirectory.getName());
            }
            catch (Exception e) {
                log.debug("Process {} is not executing in a known repository directory. Hook configuration will not be applied. (Error: {})", (Object)process.getCommandLine(), (Object)e.getMessage());
                return;
            }
            HookRequestHandle handle = this.hookService.registerRequest(repositoryId);
            HookUtils.configure((HookRequestHandle)handle, (ExternalProcessSettings)settings);
            process.addMonitor((ProcessMonitor)new HookRequestCleanupProcessMonitor(handle));
        } else {
            log.debug("Not configuring hooks for '{}' because it's not being executed in a repository directory ({})", (Object)process.getCommandLine(), (Object)workingDirectory);
        }
    }

    private static class HookRequestCleanupProcessMonitor
    implements ProcessMonitor {
        private final HookRequestHandle handle;

        private HookRequestCleanupProcessMonitor(HookRequestHandle handle) {
            this.handle = handle;
        }

        public void onBeforeStart(ExternalProcess process) {
        }

        public void onAfterFinished(ExternalProcess process) {
            this.handle.close();
        }
    }
}

