/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.content.Blame;
import com.atlassian.stash.content.ContentService;
import com.atlassian.stash.content.ContentTreeCallback;
import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.content.FileContentCallback;
import com.atlassian.stash.content.FileContext;
import com.atlassian.stash.content.FileSummary;
import com.atlassian.stash.content.InternalBlame;
import com.atlassian.stash.exception.CommandException;
import com.atlassian.stash.exception.NoSuchPathException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.user.InternalUserService;
import com.atlassian.stash.io.TypeAwareOutputSupplier;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.BlameCommandParameters;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.DirectoryCommandParameters;
import com.atlassian.stash.scm.FileCommandParameters;
import com.atlassian.stash.scm.RawFileCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.scm.TypeCommandParameters;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PredicateUtils;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ContentService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="contentService")
public class DefaultContentService
extends AbstractScmService
implements ContentService {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentService.class);
    private final I18nService i18nService;
    private final InternalUserService userService;

    @Autowired
    public DefaultContentService(ScmService scmService, I18nService i18nService, InternalUserService userService) {
        super(scmService);
        this.i18nService = i18nService;
        this.userService = userService;
    }

    @Nonnull
    public List<Blame> getBlame(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull PageRequest pageRequest) {
        List blame = (List)this.getCommandFactory(repository).blame(((BlameCommandParameters.Builder)((BlameCommandParameters.Builder)new BlameCommandParameters.Builder().changesetId(objectId)).path(path)).build(), pageRequest).call();
        return blame == null ? Collections.emptyList() : this.updateAuthors(blame);
    }

    @Nonnull
    public ContentTreeNode.Type getType(@Nonnull Repository repository, @Nonnull String objectId, String path) {
        ContentTreeNode.Type type = (ContentTreeNode.Type)this.getCommandFactory(repository).type(((TypeCommandParameters.Builder)((TypeCommandParameters.Builder)new TypeCommandParameters.Builder().changesetId(objectId)).path(path)).build()).call();
        if (type == null) {
            throw new NoSuchPathException(this.i18nService.createKeyedMessage("stash.service.content.type.none", new Object[]{path, objectId}), path, objectId);
        }
        return type;
    }

    public void streamDirectory(@Nonnull Repository repository, @Nonnull String objectId, String path, boolean recursive, @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(recursive ? this.maxDirectoryRecursiveChildren : this.maxDirectoryChildren);
        DirectoryCommandParameters parameters = ((DirectoryCommandParameters.Builder)((DirectoryCommandParameters.Builder)new DirectoryCommandParameters.Builder().changesetId(objectId)).path(path)).recurse(recursive).build();
        this.getCommandFactory(repository).directory(parameters, callback, pageRequest).call();
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull PageRequest pageRequest, boolean withBlame, @Nonnull FileContentCallback callback) throws ServiceException {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxSourceLines);
        if (withBlame) {
            callback = new AuthorUpdatingFileContentCallback(callback);
        }
        FileCommandParameters parameters = ((FileCommandParameters.Builder)((FileCommandParameters.Builder)new FileCommandParameters.Builder().annotate(withBlame).changesetId(objectId)).maxLineLength(this.maxLineLength).path(path)).build();
        Command command = this.getCommandFactory(repository).file(parameters, callback, pageRequest);
        try {
            command.call();
        }
        catch (CommandException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            log.error("{}: Error streaming {}:{}", new Object[]{repository, objectId, path, rootCause});
            throw this.unexpectedError(rootCause);
        }
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull TypeAwareOutputSupplier outputStreamSupplier) throws ServiceException {
        RawFileCommandParameters parameters = ((RawFileCommandParameters.Builder)((RawFileCommandParameters.Builder)new RawFileCommandParameters.Builder().changesetId(objectId)).path(path)).build();
        this.getCommandFactory(repository).rawFile(parameters, outputStreamSupplier).call();
    }

    private ServerException unexpectedError(Throwable cause) {
        throw new ServerException(this.i18nService.createKeyedMessage("stash.service.unexpected", new Object[0]), cause);
    }

    private List<Blame> updateAuthors(List<? extends Blame> blames) {
        if (CollectionUtils.isEmpty(blames)) {
            return blames;
        }
        Set emailAddresses = Chainable.chain(blames).transform(Blame.TO_AUTHOR).transform(Person.TO_EMAIL_ADDRESS).filter(PredicateUtils.notBlank()).toSet();
        final Map usersByEmail = this.userService.mapUsersByEmail(emailAddresses);
        if (!usersByEmail.isEmpty()) {
            blames = Chainable.chain(blames).transform((Function)new Function<Blame, Blame>(){

                public Blame apply(Blame blame) {
                    StashUser user = (StashUser)usersByEmail.get(blame.getAuthor().getEmailAddress());
                    if (user != null) {
                        blame = new InternalBlame.Builder(blame).author((Person)user).build();
                    }
                    return blame;
                }
            }).toList();
        }
        return blames;
    }

    private class AuthorUpdatingFileContentCallback
    implements FileContentCallback {
        private final FileContentCallback delegate;

        public AuthorUpdatingFileContentCallback(FileContentCallback callback) {
            this.delegate = callback;
        }

        public void offerBlame(@Nonnull List<? extends Blame> blames) throws IOException {
            this.delegate.offerBlame(DefaultContentService.this.updateAuthors(blames));
        }

        public void onBinary() throws IOException {
            this.delegate.onBinary();
        }

        public void onEnd(@Nonnull FileSummary summary) throws IOException {
            this.delegate.onEnd(summary);
        }

        public void onStart(@Nonnull FileContext context) throws IOException {
            this.delegate.onStart(context);
        }

        public boolean onLine(int lineNumber, String line, boolean truncated) throws IOException {
            return this.delegate.onLine(lineNumber, line, truncated);
        }
    }
}

