/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import com.atlassian.stash.internal.config.DataSourceConfigAmendment;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.LineProcessor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nonnull;

class ConfigurationLineProcessor
implements LineProcessor<Boolean> {
    private static final Set<String> JDBC_TOKENS = ImmutableSet.of((Object)"jdbc.driver", (Object)"jdbc.url", (Object)"jdbc.user", (Object)"jdbc.password");
    private final BufferedWriter writer;
    private final DataSourceConfigAmendment amendment;
    private boolean amendmentDelivered;

    ConfigurationLineProcessor(@Nonnull BufferedWriter writer, @Nonnull DataSourceConfigAmendment amendment) {
        this.writer = writer;
        this.amendment = amendment;
    }

    public boolean processLine(String line) throws IOException {
        if (this.partOfCommentBlock(line)) {
            this.writeAmendment();
        } else if (this.isJdbcPropertyLine(line)) {
            this.writeAmendment();
            this.commentOut(line);
        } else {
            this.passStraightThrough(line);
        }
        return true;
    }

    public Boolean getResult() {
        return this.amendmentDelivered;
    }

    private void writeAmendment() {
        if (!this.amendmentDelivered) {
            this.amendment.writeTo(this.writer);
            this.amendmentDelivered = true;
        }
    }

    private boolean partOfCommentBlock(String line) {
        return line.trim().startsWith("#>");
    }

    private boolean isJdbcPropertyLine(String line) {
        return Iterables.any(JDBC_TOKENS, (Predicate)Predicates.equalTo((Object)this.propertyKey(line)));
    }

    private String propertyKey(String line) {
        return (String)Iterables.getFirst((Iterable)Splitter.on((char)'=').trimResults().split((CharSequence)line), (Object)"");
    }

    private void commentOut(String line) throws IOException {
        this.writer.write("# ");
        this.writer.write(line);
        this.writer.write(10);
    }

    private void passStraightThrough(String line) throws IOException {
        this.writer.write(line);
        this.writer.write(10);
    }
}

