/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.concurrent.BucketedExecutorSettings;
import com.atlassian.stash.concurrent.ConcurrencyService;
import com.atlassian.stash.concurrent.VersionTracker;
import com.atlassian.stash.event.cluster.ClusterMembershipEvent;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.BucketedExecutorFactory;
import com.atlassian.stash.internal.concurrent.DelegatingInternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.HazelcastVersionTracker;
import com.atlassian.stash.internal.concurrent.InternalBucketedExecutor;
import com.atlassian.stash.internal.concurrent.InternalConcurrencyService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.hazelcast.core.HazelcastInstance;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ConcurrencyService.class)
@Service(value="concurrencyService")
public class HazelcastConcurrencyService
implements InternalConcurrencyService {
    private final ConcurrentMap<String, InternalBucketedExecutor> bucketedExecutors;
    private final BucketedExecutorFactory executorFactory;
    private final HazelcastInstance hazelcast;
    private volatile boolean shutdown;

    @Autowired
    public HazelcastConcurrencyService(BucketedExecutorFactory executorFactory, HazelcastInstance hazelcast) {
        this.executorFactory = executorFactory;
        this.hazelcast = hazelcast;
        this.bucketedExecutors = Maps.newConcurrentMap();
    }

    @Unsecured(value="This is an internal service method")
    public <T extends Serializable> InternalBucketedExecutor<T> getBucketedExecutor(@Nonnull String name) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"service has been shut down");
        return this.wrap((InternalBucketedExecutor)this.bucketedExecutors.get(Preconditions.checkNotNull((Object)name, (Object)"name")), name);
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public <T extends Serializable> InternalBucketedExecutor<T> getBucketedExecutor(@Nonnull String name, @Nonnull BucketedExecutorSettings<T> settings) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"service has been shut down");
        Preconditions.checkNotNull(settings, (Object)"settings");
        InternalBucketedExecutor<T> executor = (InternalBucketedExecutor<T>)this.bucketedExecutors.get(Preconditions.checkNotNull((Object)name, (Object)"name"));
        if (executor == null) {
            InternalBucketedExecutor<T> newExecutor = this.executorFactory.create(name, settings);
            executor = this.bucketedExecutors.putIfAbsent(name, newExecutor);
            if (executor == null) {
                executor = newExecutor;
            } else {
                newExecutor.shutdown();
            }
        }
        return this.wrap(executor, name);
    }

    @Nonnull
    @Unsecured(value="Available to all internal code and plugins")
    public <K extends Serializable> VersionTracker<K> getVersionTracker(@Nonnull String name) {
        return new HazelcastVersionTracker(this.hazelcast.getMap("versiontracker." + (String)Preconditions.checkNotNull((Object)name, (Object)"name")));
    }

    @EventListener
    public void onNodeAddedOrRemoved(ClusterMembershipEvent event) {
        int nodeCount = event.getCurrentNodes().size();
        for (InternalBucketedExecutor executor : this.bucketedExecutors.values()) {
            executor.updateClusterSize(nodeCount);
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        for (InternalBucketedExecutor executor : Iterables.consumingIterable(this.bucketedExecutors.values())) {
            executor.shutdown();
        }
    }

    private <T extends Serializable> InternalBucketedExecutor<T> wrap(final InternalBucketedExecutor<T> executor, final String name) {
        return executor == null ? null : new DelegatingInternalBucketedExecutor<T>(executor){

            @Override
            public void shutdown() {
                super.shutdown();
                HazelcastConcurrencyService.this.bucketedExecutors.remove(name, executor);
            }
        };
    }
}

