/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.hazelcast.BaseEntryProcessor;
import com.atlassian.hazelcast.serialization.OsgiSafe;
import com.atlassian.stash.internal.concurrent.BucketKey;
import com.atlassian.stash.internal.concurrent.TaskBucket;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class ClaimTasksFromBucketProcessor<T>
extends BaseEntryProcessor<BucketKey, TaskBucket<OsgiSafe<T>>> {
    private final int numberToTake;

    ClaimTasksFromBucketProcessor(int numberToTake) {
        this.numberToTake = numberToTake;
    }

    public List<OsgiSafe<T>> process(Map.Entry<BucketKey, TaskBucket<OsgiSafe<T>>> entry) {
        TaskBucket<OsgiSafe<T>> bucket = entry.getValue();
        if (bucket == null || bucket.isEmpty()) {
            return Collections.emptyList();
        }
        if (bucket.isExecuting()) {
            return null;
        }
        bucket.setExecuting(true);
        List<OsgiSafe<T>> result = bucket.take(this.numberToTake);
        entry.setValue(bucket);
        return result;
    }
}

