/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.comment.AddDiffCommentRequest;
import com.atlassian.stash.comment.AddFileCommentRequest;
import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.comment.DiffCommentAnchor;
import com.atlassian.stash.comment.NoSuchCommentException;
import com.atlassian.stash.commit.CommitDiscussion;
import com.atlassian.stash.commit.CommitDiscussionCommentAnchor;
import com.atlassian.stash.commit.CommitEnricher;
import com.atlassian.stash.commit.CommitService;
import com.atlassian.stash.commit.graph.TraversalCallback;
import com.atlassian.stash.commit.graph.TraversalRequest;
import com.atlassian.stash.content.BatchingChangesetCallback;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.ChangeCallback;
import com.atlassian.stash.content.ChangesRequest;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.ChangesetsBetweenRequest;
import com.atlassian.stash.content.DetailedChangeset;
import com.atlassian.stash.content.DetailedChangesetsRequest;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.content.DiffContentFilter;
import com.atlassian.stash.content.DiffRequest;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.CommentCountChangeCallback;
import com.atlassian.stash.internal.comment.CommentCountChangeTransform;
import com.atlassian.stash.internal.comment.CommentCounts;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.commit.CommitDiscussionRequest;
import com.atlassian.stash.internal.commit.CommitDiscussionSource;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitService;
import com.atlassian.stash.internal.commit.graph.CommitGraphSource;
import com.atlassian.stash.internal.content.DiffContentCallbackFilter;
import com.atlassian.stash.internal.content.InternalChangeLocation;
import com.atlassian.stash.internal.content.comment.InternalCommitDiscussionCommentHelper;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ChangesCommandParameters;
import com.atlassian.stash.scm.CommitCommandParameters;
import com.atlassian.stash.scm.CommitsCommandParameters;
import com.atlassian.stash.scm.DetailedCommitsCommandParameters;
import com.atlassian.stash.scm.DiffCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.atlassian.stash.watcher.Watcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=CommitService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="commitService")
public class DefaultCommitService
extends AbstractScmService
implements InternalCommitService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommitService.class);
    private final InternalCommitDiscussionCommentHelper commentHelper;
    private final CommitDiscussionSource discussionSource;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final CommitGraphSource graphSource;
    private final InternalWatcherService watcherService;
    private final CommitEnricher enricher;

    @Autowired
    public DefaultCommitService(CommitEnricher enricher, InternalCommitDiscussionCommentHelper commentHelper, CommitDiscussionSource discussionSource, CommitGraphSource graphSource, I18nService i18nService, ScmService scmService, PermissionService permissionService, InternalWatcherService watcherService) {
        super(scmService);
        this.commentHelper = commentHelper;
        this.discussionSource = discussionSource;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.graphSource = graphSource;
        this.watcherService = watcherService;
        this.enricher = enricher;
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addComment(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        return this.commentHelper.create((InternalCommentable)this.getDiscussion(repository, commitId, true, true), commentText);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addDiffComment(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull AddDiffCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.commentHelper.createDiffComment((InternalCommentable)this.getDiscussion(repository, commitId, true, true), request);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addFileComment(@Nonnull Repository repository, @Nonnull String commitId, @Nonnull AddFileCommentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return this.commentHelper.createFileComment((InternalCommentable)this.getDiscussion(repository, commitId, true, true), request);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment addReply(@Nonnull Repository repository, @Nonnull String commitId, long commentId, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        return this.commentHelper.createReply((InternalCommentable)this.getDiscussionOrNoComment(repository, commitId, true), commentId, commentText);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public boolean deleteComment(@Nonnull Repository repository, @Nonnull String commitId, long commentId, int commentVersion) {
        InternalCommitDiscussion discussion = this.findDiscussionById(repository, commitId);
        return discussion != null && this.commentHelper.delete((InternalCommentable)discussion, commentId, commentVersion);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public Iterable<DiffCommentAnchor> findCommentAnchors(@Nonnull Repository repository, @Nonnull String commitId, String parentId, @Nonnull String path) {
        Preconditions.checkArgument((!((String)Preconditions.checkNotNull((Object)path, (Object)"path")).trim().isEmpty() ? 1 : 0) != 0, (Object)"A non-blank path is required");
        InternalCommitDiscussion discussion = this.findDiscussionById(repository, commitId);
        if (discussion == null) {
            return Collections.emptyList();
        }
        return this.commentHelper.findDiffAnchors(discussion, parentId, path);
    }

    public InternalCommitDiscussion findDiscussionById(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.getDiscussion(repository, commitId, false, false);
    }

    @PreAuthorize(value="hasRepositoryPermission(#discussion.repository, 'REPO_READ')")
    public CommitDiscussionCommentAnchor getAnchorByComment(@Nonnull CommitDiscussion discussion, long commentId) {
        return this.commentHelper.getAnchorByComment(InternalConverter.convertToInternalCommitDiscussion((CommitDiscussion)discussion), commentId);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<Change> getChanges(@Nonnull ChangesRequest request, @Nonnull PageRequest pageRequest) {
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxChanges);
        ChangesCommandParameters parameters = ((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder(request).maxChanges(this.maxChanges)).build();
        Page page = (Page)this.getCommandFactory(request.getRepository()).changes(parameters, pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        } else {
            Map<InternalChangeLocation, CommentCounts> countsByLocation = this.getCountsByLocation(request);
            if (!countsByLocation.isEmpty()) {
                page = page.transform((Function)new CommentCountChangeTransform(countsByLocation));
            }
        }
        return page;
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId) {
        return this.getChangeset(repository, changesetId, null, null);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path) {
        return this.getChangeset(repository, changesetId, path, null);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable Collection<String> attributesToLoad) {
        return this.getChangeset(repository, changesetId, null, attributesToLoad);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path, @Nullable Collection<String> attributesToLoad) {
        Changeset changeset = (Changeset)this.getCommandFactory(repository).commit(((CommitCommandParameters.Builder)((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().changesetId(changesetId)).path(path)).build()).call();
        return this.enricher.enrich(repository, changeset, attributesToLoad);
    }

    @Nonnull
    public Page<Changeset> getChangesets(@Nonnull Repository repository, @Nullable String changesetId, @Nullable String path, @Nonnull PageRequest pageRequest) {
        return this.getChangesets(repository, changesetId, path, Collections.emptySet(), pageRequest);
    }

    @Nonnull
    public Page<Changeset> getChangesets(@Nonnull Repository repository, @Nullable String changesetId, @Nullable String path, @Nullable Collection<String> attributesToLoad, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxCommits);
        Page changesets = (Page)this.getCommandFactory(repository).commits(new CommitsCommandParameters.Builder().include(changesetId, new String[0]).path(path).build(), pageRequest).call();
        if (changesets == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.enricher.enrich(repository, changesets, attributesToLoad);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public Page<Changeset> getChangesetsBetween(@Nonnull ChangesetsBetweenRequest request, @Nonnull PageRequest pageRequest) {
        pageRequest = ((PageRequest)Preconditions.checkNotNull((Object)pageRequest, (Object)"pageRequest")).buildRestrictedPageRequest(this.maxCommits);
        Page changesets = (Page)this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), pageRequest).call();
        if (changesets == null) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        return this.enricher.enrich(request.getRepository(), changesets, (Collection)request.getLoadAttributes());
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    public Comment getComment(@Nonnull Repository repository, @Nonnull String commitId, long commentId) {
        return this.commentHelper.getById((InternalCommentable)this.getDiscussionOrNoComment(repository, commitId, false), commentId);
    }

    @Nonnull
    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public Page<DetailedChangeset> getDetailedChangesets(DetailedChangesetsRequest request, PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxCommits);
        Page page = (Page)this.getCommandFactory(request.getRepository()).detailedCommits(new DetailedCommitsCommandParameters.Builder().changesetIds(request.getChangesetIds()).maxChangesPerCommit(Math.min(request.getMaxChangesPerCommit(), this.maxChanges)).ignoreMissing(request.isIgnoreMissing()).build(), pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void streamChanges(@Nonnull ChangesRequest request, @Nonnull ChangeCallback callback) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Map<InternalChangeLocation, CommentCounts> countsByLocation = this.getCountsByLocation(request);
        if (!countsByLocation.isEmpty()) {
            callback = new CommentCountChangeCallback(callback, countsByLocation);
        }
        this.getCommandFactory(((ChangesRequest)Preconditions.checkNotNull((Object)request, (Object)"request")).getRepository()).changes(((ChangesCommandParameters.Builder)new ChangesCommandParameters.Builder(request).maxChanges(this.maxChanges)).build(), callback).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository) and isRepositoryAccessible(#request.secondaryRepository)")
    public void streamChangesetsBetween(final @Nonnull ChangesetsBetweenRequest request, @Nonnull ChangesetCallback callback) {
        callback = new BatchingChangesetCallback((ChangesetCallback)callback, 25){

            protected boolean onChangesets(Iterable<Changeset> changesets) throws IOException {
                changesets = DefaultCommitService.this.enricher.enrich(request.getRepository(), changesets, (Collection)request.getLoadAttributes());
                return super.onChangesets(changesets);
            }
        };
        this.getCommandFactory(request.getRepository()).commits(new CommitsCommandParameters.Builder(request).build(), callback).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void streamDiff(@Nonnull DiffRequest request, @Nonnull DiffContentCallback callback) {
        InternalCommitDiscussion discussion;
        Preconditions.checkNotNull((Object)request, (Object)"request");
        Preconditions.checkNotNull((Object)request, (Object)"callback");
        if (this.includeComments(request) && (discussion = this.findDiscussionById(request.getRepository(), request.getUntilId())) != null) {
            try {
                callback.offerAnchors(this.commentHelper.findDiffAnchors(discussion, request.getSinceId(), (String)Iterables.getFirst((Iterable)request.getPaths(), null)));
            }
            catch (IOException exc) {
                log.error("Error while callback.offerAnchors", (Throwable)exc);
            }
        }
        Repository repository = request.getRepository();
        this.getCommandFactory(repository).diff(((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)((DiffCommandParameters.Builder)new DiffCommandParameters.Builder().contextLines(request.hasContextLines() ? request.getContextLines() : this.diffContext)).maxLineLength(this.maxLineLength)).maxLines(this.maxDiffLines)).paths((Iterable)request.getPaths())).sinceId(request.getSinceId()).untilId(request.getUntilId()).whitespace(request.getWhitespace())).build(), DiffContentCallbackFilter.filter((DiffContentCallback)callback, (DiffContentFilter)request.getFilter())).call();
    }

    @PreAuthorize(value="isRepositoryAccessible(#request.repository)")
    public void traverse(@Nonnull TraversalRequest request, @Nonnull TraversalCallback callback) {
        this.graphSource.traverse(request, callback);
    }

    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public boolean unwatch(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.watcherService.removeCurrentUserAsWatcher((InternalWatchable)this.getDiscussion(repository, commitId, true, false));
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Comment updateComment(@Nonnull Repository repository, @Nonnull String commitId, long commentId, int commentVersion, @Nonnull String commentText) {
        Preconditions.checkNotNull((Object)commentText, (Object)"commentText");
        return this.commentHelper.update((InternalCommentable)this.getDiscussionOrNoComment(repository, commitId, false), commentId, commentVersion, commentText);
    }

    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
    @Transactional
    public Watcher watch(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.watcherService.addCurrentUserAsWatcher((InternalWatchable)this.getDiscussion(repository, commitId, true, false));
    }

    private Map<InternalChangeLocation, CommentCounts> getCountsByLocation(ChangesRequest request) {
        InternalCommitDiscussion discussion;
        Map countsByLocation = Collections.emptyMap();
        if (this.includeCounts(request) && (discussion = this.findDiscussionById(request.getRepository(), request.getUntilId())) != null) {
            countsByLocation = this.commentHelper.countsByLocation((InternalCommentable)discussion);
        }
        return countsByLocation;
    }

    private InternalCommitDiscussion getDiscussion(Repository repository, String commitId, boolean create, boolean participate) {
        return this.discussionSource.get(new CommitDiscussionRequest.Builder(repository, commitId).create(create).participate(participate).build());
    }

    @Nonnull
    private InternalCommitDiscussion getDiscussionOrNoComment(Repository repository, String commitId, boolean participate) {
        InternalCommitDiscussion discussion = this.getDiscussion(repository, commitId, false, participate);
        if (discussion == null) {
            throw new NoSuchCommentException(this.i18nService.createKeyedMessage("stash.service.comment.nosuchcomment", new Object[0]));
        }
        return discussion;
    }

    private boolean includeComments(DiffRequest request) {
        return request.isWithComments() && this.permissionService.hasRepositoryPermission(request.getRepository(), Permission.REPO_READ);
    }

    private boolean includeCounts(ChangesRequest request) {
        return request.isWithComments() && this.permissionService.hasRepositoryPermission(request.getRepository(), Permission.REPO_READ);
    }
}

