/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.commit.CommitDiscussion;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.event.commit.CommitDiscussionParticipantsUpdatedEvent;
import com.atlassian.stash.exception.NoSuchChangesetException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.commit.CommitDiscussionDao;
import com.atlassian.stash.internal.commit.CommitDiscussionParticipantDao;
import com.atlassian.stash.internal.commit.CommitDiscussionRequest;
import com.atlassian.stash.internal.commit.CommitDiscussionSource;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.CommitCommandParameters;
import com.atlassian.stash.scm.ScmService;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="commitDiscussionSource")
public class DefaultCommitDiscussionSource
implements CommitDiscussionSource {
    private final StashAuthenticationContext authenticationContext;
    private final CommitDiscussionDao discussionDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final CommitDiscussionParticipantDao participantDao;
    private final ScmService scmService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final InternalWatcherService watcherService;

    @Autowired
    public DefaultCommitDiscussionSource(StashAuthenticationContext authenticationContext, CommitDiscussionDao discussionDao, EventPublisher eventPublisher, I18nService i18nService, CommitDiscussionParticipantDao participantDao, ScmService scmService, PlatformTransactionManager transactionManager, UserService userService, InternalWatcherService watcherService) {
        this.authenticationContext = authenticationContext;
        this.discussionDao = discussionDao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.participantDao = participantDao;
        this.scmService = scmService;
        this.userService = userService;
        this.watcherService = watcherService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
    }

    @Override
    public InternalCommitDiscussion get(@Nonnull CommitDiscussionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        InternalCommitDiscussion discussion = this.doGet(request);
        if (discussion != null && request.isParticipate()) {
            this.maybeAddParticipant(discussion);
        }
        return discussion;
    }

    private void addParticipant(InternalCommitDiscussion discussion, StashUser user) {
        this.participantDao.create((Object)((InternalCommitDiscussionParticipant.Builder)new InternalCommitDiscussionParticipant.Builder(discussion).user(InternalConverter.convertToInternalUser((StashUser)user))).build());
        this.watcherService.addUserAsWatcher((InternalWatchable)discussion, user);
        this.eventPublisher.publish((Object)new CommitDiscussionParticipantsUpdatedEvent((Object)this, (CommitDiscussion)discussion, Collections.singleton(user), Collections.emptySet()));
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion) {
        this.maybeAddParticipant(discussion, this.authenticationContext.getCurrentUser());
    }

    private void maybeAddParticipant(InternalCommitDiscussion discussion, StashUser user) {
        InternalCommitDiscussionParticipant participant = this.participantDao.findByDiscussionAndUser(discussion.getId(), user.getId().intValue());
        if (participant == null) {
            this.addParticipant(discussion, user);
        }
    }

    private InternalCommitDiscussion doGet(CommitDiscussionRequest request) {
        String commitId = request.getCommitId();
        Repository repository = request.getRepository();
        InternalCommitDiscussion discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId().intValue(), commitId);
        if (request.isCreate() && discussion == null) {
            Changeset changeset = (Changeset)this.scmService.getCommandFactory(repository).commit(((CommitCommandParameters.Builder)new CommitCommandParameters.Builder().changesetId(commitId)).build()).call();
            if (changeset == null) {
                throw new NoSuchChangesetException(this.i18nService.createKeyedMessage("", new Object[0]), commitId);
            }
            discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId().intValue(), changeset.getId());
            if (discussion == null) {
                try {
                    StashUser author = this.findAuthor(changeset);
                    discussion = this.createDiscussion(repository, changeset, author);
                }
                catch (RuntimeException e) {
                    if (this.isDataIntegrityViolation(e) && (discussion = this.discussionDao.findByRepositoryAndCommit(repository.getId().intValue(), changeset.getId())) != null) {
                        return discussion;
                    }
                    throw e;
                }
            }
        }
        return discussion;
    }

    private InternalCommitDiscussion createDiscussion(final @Nonnull Repository repository, final @Nonnull Changeset changeset, final @Nullable StashUser author) {
        return (InternalCommitDiscussion)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<InternalCommitDiscussion>(){

            public InternalCommitDiscussion doInTransaction(TransactionStatus transactionStatus) {
                InternalCommitDiscussion discussion = (InternalCommitDiscussion)DefaultCommitDiscussionSource.this.discussionDao.create((Object)new InternalCommitDiscussion.Builder(InternalConverter.convertToInternalRepository((Repository)repository), changeset.getId()).parents(changeset.getParents()).build());
                if (author != null) {
                    DefaultCommitDiscussionSource.this.addParticipant(discussion, author);
                }
                return discussion;
            }
        });
    }

    private StashUser findAuthor(Changeset changeset) {
        String emailAddress = changeset.getAuthor().getEmailAddress();
        return StringUtils.isNotBlank((CharSequence)emailAddress) ? this.userService.findUserByNameOrEmail(emailAddress) : null;
    }

    private boolean isDataIntegrityViolation(RuntimeException e) {
        return Iterables.any((Iterable)Throwables.getCausalChain((Throwable)e), (Predicate)Predicates.instanceOf(DataIntegrityViolationException.class));
    }
}

