/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.cgi;

import com.atlassian.stash.scm.CommandOutputHandler;
import com.atlassian.stash.web.cgi.BaseCgiHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.Watchdog;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

public class CgiOutputHandler
extends BaseCgiHandler
implements CommandOutputHandler<Void> {
    private final HttpServletResponse response;

    public CgiOutputHandler(HttpServletResponse response, int bufferSize) {
        super(bufferSize);
        this.response = response;
    }

    public void complete() throws ProcessException {
    }

    public Void getOutput() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InputStream inputStream) throws ProcessException {
        try {
            String line;
            while ((line = this.getTextLineFromStream(inputStream)).length() > 0) {
                if (line.startsWith("HTTP")) continue;
                this.processHeader(line);
            }
            this.copyStream(inputStream, (OutputStream)this.response.getOutputStream());
        }
        catch (IOException e) {
            LOG.info("Failed to copy SCM hosting process output to response output stream", (Throwable)(LOG.isDebugEnabled() ? e : null));
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    public void setWatchdog(Watchdog watchdog) {
        super.setWatchdog(watchdog);
    }

    private void processHeader(String line) throws IOException {
        int k = line.indexOf(58);
        if (k < 1) {
            return;
        }
        String key = line.substring(0, k).trim();
        String value = line.substring(k + 1).trim();
        if ("Location".equals(key)) {
            this.response.sendRedirect(this.response.encodeRedirectURL(value));
        } else if ("Status".equals(key)) {
            String[] token = value.split(" ");
            int status = Integer.parseInt(token[0]);
            this.response.setStatus(status);
        } else {
            this.response.addHeader(key, value);
        }
    }
}

