/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.ssh;

import com.atlassian.stash.scm.CommandInputHandler;
import com.atlassian.stash.scm.ssh.AbstractSshStreamHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SshInputHandler
extends AbstractSshStreamHandler
implements CommandInputHandler {
    private final int bufferSize;
    private final InputStream inputStream;

    public SshInputHandler(int bufferSize, InputStream inputStream) {
        this.bufferSize = bufferSize;
        this.inputStream = (InputStream)Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream");
    }

    public void process(OutputStream outputStream) {
        try {
            this.copyStream(this.inputStream, outputStream, this.bufferSize);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy stream from SSH client to forked process", e);
        }
    }
}

