/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.protocol;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.AbstractScmRequestHandlerModuleDescriptor;
import com.atlassian.stash.scm.Scm;
import com.atlassian.stash.scm.ScmProtocol;
import com.atlassian.stash.scm.ScmUrlFormatter;
import com.atlassian.stash.scm.ScmUrlRequest;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.Chainable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPluginScmProtocol<D extends AbstractScmRequestHandlerModuleDescriptor>
implements ScmProtocol {
    protected final Logger log;
    private final Class<D> descriptorClass;
    private final PluginAccessor pluginAccessor;
    private final Function<D, ScmUrlFormatter> toFormatter;
    private final ScmUrlFormatter urlFormatter;

    protected AbstractPluginScmProtocol(PluginAccessor pluginAccessor, ScmUrlFormatter urlFormatter) {
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.urlFormatter = (ScmUrlFormatter)Preconditions.checkNotNull((Object)urlFormatter, (Object)"urlFormatter");
        this.descriptorClass = (Class)ClassUtils.getTypeArguments(AbstractPluginScmProtocol.class, this.getClass()).get(0);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.toFormatter = new Function<D, ScmUrlFormatter>(){

            public ScmUrlFormatter apply(D descriptor) {
                return descriptor.getUrlFormatter();
            }
        };
    }

    public String getCloneUrl(@Nonnull Repository repository, StashUser user) {
        Preconditions.checkNotNull((Object)"repository", (Object)repository);
        String baseUrl = this.getBaseUrl();
        ScmUrlFormatter formatter = (ScmUrlFormatter)Iterables.getFirst((Iterable)Chainable.chain(this.getHandlerDescriptors()).filter(this.isScm(repository.getScmId())).transform(this.toFormatter).filter(Predicates.notNull()), (Object)this.urlFormatter);
        try {
            return formatter.format(new ScmUrlRequest.Builder(repository, new URI(baseUrl)).user(user).build()).toASCIIString();
        }
        catch (URISyntaxException e) {
            this.log.warn("{}: Failed to format URL; using base URL", (Object)repository, (Object)e);
            return String.format("%s/%s/%s", baseUrl, repository.getProject().getKey().toLowerCase(Locale.US), repository.getSlug());
        }
    }

    public boolean supports(@Nonnull Scm scm) {
        Preconditions.checkNotNull((Object)"scm", (Object)scm);
        return Iterables.any(this.getHandlerDescriptors(), this.isScm(scm.getId()));
    }

    @Nonnull
    protected abstract String getBaseUrl();

    private List<D> getHandlerDescriptors() {
        ArrayList descriptors = new ArrayList(this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.descriptorClass));
        Collections.sort(descriptors);
        return descriptors;
    }

    private Predicate<D> isScm(final String scmId) {
        return new Predicate<D>(){

            public boolean apply(D descriptor) {
                return scmId.equals(descriptor.getScm());
            }
        };
    }
}

