/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.io;

import com.atlassian.stash.io.ContentDetectionUtils;
import com.atlassian.stash.io.ReaderLineReader;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;

public abstract class TruncatedLineOutputHandler
extends BaseOutputHandler {
    private static final int BUFFER_SIZE = 8192;
    private static final int ENCODING_BUFFER_SIZE = 32768;
    private final String encoding;
    private final int maxLineLength;
    private int counter;

    protected TruncatedLineOutputHandler(int maxLineLength) {
        this(maxLineLength, null);
    }

    protected TruncatedLineOutputHandler(int maxLineLength, String encoding) {
        this.maxLineLength = maxLineLength;
        this.encoding = encoding;
    }

    public int getLineNumber() {
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InputStream output) throws ProcessException {
        BufferedInputStream bufferedIn = new BufferedInputStream(output, 8192);
        try {
            if (ContentDetectionUtils.isBinary(bufferedIn, 8192)) {
                try {
                    this.handleBinary();
                    return;
                }
                finally {
                    this.cancelProcess();
                }
            }
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        this.process(bufferedIn);
    }

    protected void process(BufferedInputStream in) throws ProcessException {
        ReaderLineReader reader;
        String readerEncoding = this.chooseEncoding(in);
        try {
            reader = new ReaderLineReader(new InputStreamReader((InputStream)in, readerEncoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessException("Content encoding [" + readerEncoding + "] is not supported", (Throwable)e);
        }
        try {
            String line;
            while ((line = reader.readLine(this.maxLineLength + 3)) != null) {
                this.resetWatchdog();
                boolean truncated = false;
                if (line.length() > this.maxLineLength) {
                    truncated = true;
                    line = line.substring(0, this.maxLineLength);
                }
                this.processLine(this.counter++, line, truncated);
            }
            this.processInputEnd(this.counter);
        }
        catch (InterruptedIOException e) {
            this.processEndByException();
        }
        catch (IOException e) {
            this.processEndByException();
            throw new ProcessException((Throwable)e);
        }
        finally {
            Closeables.closeQuietly((Closeable)((Object)reader));
        }
    }

    protected abstract void handleBinary() throws ProcessException;

    protected void processEndByException() {
    }

    protected void processInputEnd(int lineCount) throws ProcessException {
    }

    protected abstract void processLine(int var1, String var2, boolean var3) throws ProcessException;

    private String chooseEncoding(BufferedInputStream in) throws ProcessException {
        String readerEncoding;
        if (this.encoding == null) {
            String detected;
            try {
                detected = ContentDetectionUtils.detectEncoding(in, 32768);
            }
            catch (IOException e) {
                throw new ProcessException((Throwable)e);
            }
            readerEncoding = StringUtils.defaultIfEmpty((String)detected, (String)"UTF-8");
        } else {
            readerEncoding = this.encoding;
        }
        return readerEncoding;
    }
}

