/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.io;

import com.atlassian.stash.io.LineReader;
import com.atlassian.stash.io.ReaderLineReader;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.IOUtils;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

public abstract class LineReaderOutputHandler
extends BaseOutputHandler {
    private final String encoding;

    public LineReaderOutputHandler(String encoding) {
        this.encoding = encoding;
    }

    public void process(InputStream output) throws ProcessException {
        LineReader reader = this.createReader(output);
        try {
            this.processReader(reader);
        }
        catch (InterruptedIOException ignored) {
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Object)reader));
        }
    }

    protected LineReader createReader(InputStream output) throws ProcessException {
        InputStreamReader streamReader;
        try {
            streamReader = new InputStreamReader((InputStream)new BufferedInputStream(output), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessException(this.encoding + " encoding is not supported", (Throwable)e);
        }
        return new ReaderLineReader(streamReader);
    }

    protected abstract void processReader(LineReader var1) throws IOException;

    protected String resetWatchdogAndReadLine(LineReader reader) throws IOException {
        this.resetWatchdog();
        return reader.readLine();
    }
}

