/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.io;

import com.atlassian.stash.scm.CommandInputHandler;
import com.atlassian.utils.process.BaseInputHandler;
import com.atlassian.utils.process.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class LineInputHandler
extends BaseInputHandler
implements CommandInputHandler {
    private final Iterable<String> lines;

    public LineInputHandler(Iterable<String> lines) {
        this.lines = lines;
    }

    public void process(OutputStream input) {
        OutputStreamWriter writer = new OutputStreamWriter(input);
        try {
            if (this.lines != null) {
                for (String line : this.lines) {
                    writer.write(line + "\n");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
    }
}

