/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.Directory;
import com.atlassian.stash.content.Path;
import com.atlassian.stash.content.SimplePath;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class InternalDirectory
extends Directory {
    private final Path path;
    private final String contentId;

    public InternalDirectory(Path path, String contentId) {
        this.path = path;
        this.contentId = contentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalDirectory) {
            InternalDirectory d = (InternalDirectory)((Object)o);
            return Objects.equal((Object)this.getPath(), (Object)d.getPath()) && Objects.equal((Object)this.getContentId(), (Object)d.getContentId());
        }
        return false;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getContentId()});
    }

    public String toString() {
        return "InternalDirectory{path='" + this.path + '\'' + ", contentId='" + this.contentId + '\'' + '}';
    }

    public static class Builder {
        private String contentId;
        private Path path;

        public Builder() {
        }

        public Builder(Directory file) {
            this.contentId = file.getContentId();
            this.path = file.getPath();
        }

        public InternalDirectory build() {
            return new InternalDirectory(this.path, this.contentId);
        }

        public Builder contentId(String value) {
            this.contentId = value;
            return this;
        }

        public Builder path(@Nonnull Path value) {
            this.path = (Path)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value)));
        }
    }
}

