/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.DiffLine;
import com.atlassian.stash.content.DiffSegment;
import com.atlassian.stash.content.DiffSegmentType;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;

public class InternalDiffSegment
implements DiffSegment {
    private final List<DiffLine> lines;
    private final boolean truncated;
    private final DiffSegmentType type;

    private InternalDiffSegment(DiffSegmentType type, boolean truncated, List<DiffLine> lines) {
        this.type = type;
        this.lines = lines;
        this.truncated = truncated;
    }

    @Nonnull
    public List<DiffLine> getLines() {
        return this.lines;
    }

    @Nonnull
    public DiffSegmentType getType() {
        return this.type;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final class Builder {
        private ImmutableList.Builder<DiffLine> lines = ImmutableList.builder();
        private boolean truncated;
        private DiffSegmentType type;

        public Builder() {
        }

        public Builder(DiffSegment segment) {
            this();
            this.truncated = segment.isTruncated();
            this.type = segment.getType();
            List l = segment.getLines();
            if (CollectionUtils.isNotEmpty((Collection)l)) {
                this.lines.addAll((Iterable)l);
            }
        }

        public InternalDiffSegment build() {
            return new InternalDiffSegment(this.type, this.truncated, (List)this.lines.build());
        }

        public Builder line(DiffLine value) {
            this.lines.add((Object)value);
            return this;
        }

        public Builder lines(DiffLine value, DiffLine ... values) {
            this.lines.add((Object)value).add((Object[])values);
            return this;
        }

        public Builder lines(Iterable<DiffLine> value) {
            this.lines.addAll(value);
            return this;
        }

        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }

        public Builder type(DiffSegmentType value) {
            this.type = value;
            return this;
        }
    }
}

