/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.DiffHunk;
import com.atlassian.stash.content.DiffSegment;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;

public class InternalDiffHunk
implements DiffHunk {
    private final int destinationLine;
    private final int destinationSpan;
    private final List<DiffSegment> segments;
    private final int sourceLine;
    private final int sourceSpan;
    private final boolean truncated;

    private InternalDiffHunk(int sourceLine, int sourceSpan, int destinationLine, int destinationSpan, boolean truncated, List<DiffSegment> segments) {
        this.destinationLine = destinationLine;
        this.destinationSpan = destinationSpan;
        this.segments = segments;
        this.sourceLine = sourceLine;
        this.sourceSpan = sourceSpan;
        this.truncated = truncated;
    }

    public int getDestinationLine() {
        return this.destinationLine;
    }

    public int getDestinationSpan() {
        return this.destinationSpan;
    }

    @Nonnull
    public List<DiffSegment> getSegments() {
        return this.segments;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public int getSourceSpan() {
        return this.sourceSpan;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final class Builder {
        private int destinationLine;
        private int destinationSpan;
        private ImmutableList.Builder<DiffSegment> segments = ImmutableList.builder();
        private int sourceLine;
        private int sourceSpan;
        private boolean truncated;

        public Builder() {
        }

        public Builder(DiffHunk hunk) {
            this();
            this.destinationLine = hunk.getDestinationLine();
            this.destinationSpan = hunk.getDestinationSpan();
            this.sourceLine = hunk.getSourceLine();
            this.sourceSpan = hunk.getSourceSpan();
            this.truncated = hunk.isTruncated();
            List s = hunk.getSegments();
            if (CollectionUtils.isNotEmpty((Collection)s)) {
                this.segments.addAll((Iterable)s);
            }
        }

        public InternalDiffHunk build() {
            return new InternalDiffHunk(this.sourceLine, this.sourceSpan, this.destinationLine, this.destinationSpan, this.truncated, (List)this.segments.build());
        }

        public Builder destinationLine(int value) {
            this.destinationLine = value;
            return this;
        }

        public Builder destinationSpan(int value) {
            this.destinationSpan = value;
            return this;
        }

        public Builder segment(DiffSegment value) {
            this.segments.add((Object)value);
            return this;
        }

        public Builder segments(DiffSegment value, DiffSegment ... values) {
            this.segments.add((Object)value).add((Object[])values);
            return this;
        }

        public Builder segments(Iterable<DiffSegment> value) {
            if (value != null) {
                this.segments.addAll(value);
            }
            return this;
        }

        public Builder sourceLine(int value) {
            this.sourceLine = value;
            return this;
        }

        public Builder sourceSpan(int value) {
            this.sourceSpan = value;
            return this;
        }

        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }
    }
}

