/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.Conflict;
import com.atlassian.stash.content.ConflictChange;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class InternalConflict
implements Conflict {
    private final ConflictChange ourChange;
    private final ConflictChange theirChange;

    private InternalConflict(ConflictChange ourChange, ConflictChange theirChange) {
        this.ourChange = ourChange;
        this.theirChange = theirChange;
    }

    @Nonnull
    public ConflictChange getOurChange() {
        return this.ourChange;
    }

    @Nonnull
    public ConflictChange getTheirChange() {
        return this.theirChange;
    }

    public static class Builder {
        private ConflictChange ourChange;
        private ConflictChange theirChange;

        public Builder() {
        }

        public Builder(Conflict conflict) {
            this.ourChange = conflict.getOurChange();
            this.theirChange = conflict.getTheirChange();
        }

        public InternalConflict build() {
            Preconditions.checkNotNull((Object)this.ourChange, (Object)"ourChange is required");
            Preconditions.checkNotNull((Object)this.theirChange, (Object)"theirChange is required");
            return new InternalConflict(this.ourChange, this.theirChange);
        }

        public Builder ourChange(ConflictChange value) {
            this.ourChange = (ConflictChange)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder theirChange(ConflictChange value) {
            this.theirChange = (ConflictChange)Preconditions.checkNotNull((Object)value);
            return this;
        }
    }
}

