/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.Blame;
import com.atlassian.stash.user.Person;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class InternalBlame
implements Blame {
    private final Person author;
    private final Date authorTimestamp;
    private final String commitHash;
    private final String displayCommitHash;
    private final String fileName;
    private final int lineNumber;
    private final int spannedLines;

    private InternalBlame(int lineNumber, int spannedLines, String commitHash, String displayCommitHash, String fileName, Person author, Date authorTimestamp) {
        this.author = author;
        this.authorTimestamp = authorTimestamp;
        this.commitHash = commitHash;
        this.displayCommitHash = displayCommitHash;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.spannedLines = spannedLines;
    }

    public Person getAuthor() {
        return this.author;
    }

    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public String getDisplayCommitHash() {
        return this.displayCommitHash;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getSpannedLines() {
        return this.spannedLines;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.lineNumber);
        if (this.spannedLines > 1) {
            builder.append("-").append(this.lineNumber + this.spannedLines - 1);
        }
        builder.append(":").append(this.commitHash).append(" ").append(this.author).append(" ").append(this.authorTimestamp).append(" (").append(this.fileName).append(")");
        return builder.toString();
    }

    public static final class Builder {
        private Person author;
        private Date authorTimestamp;
        private String commitHash;
        private String displayCommitHash;
        private String fileName;
        private int lineNumber;
        private int spannedLines;

        public Builder() {
        }

        public Builder(Blame blame) {
            this.author = blame.getAuthor();
            this.authorTimestamp = blame.getAuthorTimestamp();
            this.commitHash = blame.getCommitHash();
            this.displayCommitHash = blame.getDisplayCommitHash();
            this.fileName = blame.getFileName();
            this.lineNumber = blame.getLineNumber();
            this.spannedLines = blame.getSpannedLines();
        }

        public Builder author(Person value) {
            this.author = value;
            return this;
        }

        public Builder authorTimestamp(Date value) {
            this.authorTimestamp = value;
            return this;
        }

        public InternalBlame build() {
            Preconditions.checkArgument((this.lineNumber > 0 ? 1 : 0) != 0, (Object)"Line numbers begin at 1 and are required");
            Preconditions.checkArgument((this.author.getName() != null && this.authorTimestamp != null ? 1 : 0) != 0, (Object)"Author information (name and timestamp) is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.commitHash), (Object)"A commit hash is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.fileName), (Object)"A filename is required");
            if (this.displayCommitHash == null) {
                this.displayCommitHash = this.commitHash.substring(0, 11);
            }
            if (this.spannedLines < 1) {
                this.spannedLines = 1;
            }
            return new InternalBlame(this.lineNumber, this.spannedLines, this.commitHash, this.displayCommitHash, this.fileName, this.author, this.authorTimestamp);
        }

        public Builder commitHash(String value) {
            this.commitHash = value;
            return this;
        }

        public Builder fileName(String value) {
            this.fileName = value;
            return this;
        }

        public Builder lineNumber(int value) {
            this.lineNumber = value;
            return this;
        }

        public Builder spannedLines(int value) {
            this.spannedLines = value;
            return this;
        }
    }
}

