/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.ChangesetCallback;
import com.atlassian.stash.content.ChangesetContext;
import com.atlassian.stash.content.ChangesetSummary;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class BatchingChangesetCallback
implements ChangesetCallback {
    private final int batchSize;
    private final List<Changeset> cache;
    private final ChangesetCallback delegate;

    public BatchingChangesetCallback(ChangesetCallback delegate, int batchSize) {
        this.batchSize = batchSize;
        this.delegate = delegate;
        this.cache = Lists.newArrayListWithCapacity((int)batchSize);
    }

    public boolean onChangeset(@Nonnull Changeset changeset) throws IOException {
        this.cache.add(changeset);
        return this.flush(this.cache.size() >= this.batchSize);
    }

    public void onEnd(@Nonnull ChangesetSummary summary) throws IOException {
        this.flush(true);
        this.delegate.onEnd(summary);
    }

    public void onStart(@Nonnull ChangesetContext context) throws IOException {
        this.delegate.onStart(context);
    }

    protected boolean onChangesets(Iterable<Changeset> changesets) throws IOException {
        for (Changeset changeset : changesets) {
            if (this.delegate.onChangeset(changeset)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(boolean now) throws IOException {
        if (now) {
            try {
                boolean bl = this.onChangesets(this.cache);
                return bl;
            }
            finally {
                this.cache.clear();
            }
        }
        return true;
    }
}

