/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.commit.graph;

import com.atlassian.stash.commit.graph.CommitGraphNode;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import javax.annotation.Nonnull;

public class SimpleCommitGraphNode
implements CommitGraphNode {
    private final MinimalChangeset commit;
    private final Collection<MinimalChangeset> parents;

    private SimpleCommitGraphNode(MinimalChangeset commit, Collection<MinimalChangeset> parents) {
        this.commit = commit;
        this.parents = parents;
    }

    @Nonnull
    public MinimalChangeset getCommit() {
        return this.commit;
    }

    @Nonnull
    public Collection<MinimalChangeset> getParents() {
        return this.parents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleCommitGraphNode)) {
            return false;
        }
        SimpleCommitGraphNode that = (SimpleCommitGraphNode)o;
        return this.commit.equals(that.getCommit()) && this.parents.equals(that.parents);
    }

    public int hashCode() {
        return 31 * this.commit.hashCode() + this.parents.hashCode();
    }

    public String toString() {
        return "SimpleCommitGraphNode{commit=" + this.commit + ", parents=" + this.parents + '}';
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<MinimalChangeset> parents = ImmutableSet.builder();
        private MinimalChangeset commit;

        public Builder() {
        }

        public Builder(@Nonnull SimpleCommitGraphNode value) {
            this.commit(((SimpleCommitGraphNode)Preconditions.checkNotNull((Object)value, (Object)"node")).getCommit());
            this.parents(value.getParents());
        }

        public SimpleCommitGraphNode build() {
            Preconditions.checkState((this.commit != null ? 1 : 0) != 0, (Object)"A commit must be supplied");
            return new SimpleCommitGraphNode(this.commit, (Collection)this.parents.build());
        }

        public Builder commit(@Nonnull MinimalChangeset value) {
            this.commit = (MinimalChangeset)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        public Builder parents(@Nonnull Iterable<MinimalChangeset> values) {
            Builder.addIf((Predicate)Predicates.notNull(), this.parents, values);
            return this;
        }

        public Builder parents(@Nonnull MinimalChangeset value, MinimalChangeset ... values) {
            Builder.addIf((Predicate)Predicates.notNull(), this.parents, (Object)value, (Object[])values);
            return this;
        }
    }
}

