/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.util;

import com.atlassian.stash.rest.data.RestErrors;
import com.atlassian.stash.rest.util.CachePolicies;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

public class ResponseFactory {
    private ResponseFactory() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    private static Response.ResponseBuilder applyDefaults(Response.ResponseBuilder builder) {
        return builder.cacheControl(CachePolicies.noCache()).header("Vary", (Object)"X-AUSERNAME").header("Vary", (Object)"X-AUSERID").header("Vary", (Object)"Cookie");
    }

    public static Response.ResponseBuilder badRequest(String error) {
        return ResponseFactory.badRequest(null, error);
    }

    public static Response.ResponseBuilder badRequest(String context, String error) {
        return ResponseFactory.error(Response.Status.BAD_REQUEST, context, error);
    }

    public static Response.ResponseBuilder ok() {
        return ResponseFactory.applyDefaults(Response.ok());
    }

    public static Response.ResponseBuilder ok(Object entity) {
        return ResponseFactory.applyDefaults(Response.ok((Object)entity));
    }

    public static Response.ResponseBuilder ok(Object entity, CacheControl cacheControl) {
        return ResponseFactory.applyDefaults(Response.ok((Object)entity)).cacheControl(cacheControl);
    }

    public static Response.ResponseBuilder created(@Nonnull URI location) {
        return ResponseFactory.applyDefaults(Response.created((URI)location));
    }

    public static Response.ResponseBuilder noContent() {
        return ResponseFactory.applyDefaults(Response.noContent());
    }

    public static Response.ResponseBuilder notFound() {
        return ResponseFactory.applyDefaults(ResponseFactory.status(Response.Status.NOT_FOUND));
    }

    public static Response.ResponseBuilder error(@Nonnull Response.Status status, String context, String error) {
        return ResponseFactory.errors(status, new RestErrors(context, error));
    }

    public static Response.ResponseBuilder errors(@Nonnull Response.Status status, RestErrors errors) {
        return ResponseFactory.status(status).entity((Object)errors);
    }

    public static Response.ResponseBuilder status(@Nonnull Response.Status status) {
        return ResponseFactory.applyDefaults(Response.status((Response.Status)status));
    }

    public static Response.ResponseBuilder serverError() {
        return ResponseFactory.applyDefaults(Response.serverError());
    }
}

