/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.util;

import com.atlassian.stash.rest.util.StatefulJsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class JsonStreamingOutput
implements StreamingOutput {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream output) throws IOException, WebApplicationException {
        try (StatefulJsonWriter writer = new StatefulJsonWriter(new ObjectMapper().getJsonFactory().createJsonGenerator(JsonStreamingOutput.wrap(output), JsonEncoding.UTF8));){
            this.write(writer);
        }
    }

    public abstract void write(StatefulJsonWriter var1) throws IOException, WebApplicationException;

    private static OutputStream wrap(OutputStream stream) {
        try {
            return new CloseShieldOutputStream(stream);
        }
        catch (NoClassDefFoundError e) {
            return stream;
        }
    }
}

