/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.renderer;

import com.atlassian.stash.rest.renderer.SurrogateBuilder;
import java.lang.reflect.Constructor;

public class DefaultSurrogateBuilder
implements SurrogateBuilder {
    private final Constructor<?> ctor;
    private final Object[] extraCtorArgs;

    public DefaultSurrogateBuilder(Constructor<?> ctor, Object ... extraCtorArgs) {
        this.ctor = ctor;
        this.extraCtorArgs = extraCtorArgs;
        if (ctor.getParameterTypes().length != extraCtorArgs.length + 1) {
            throw new IllegalArgumentException(String.format("Incorrect number of arguments for the supplied constructor: %d expected but constructor supports %d", ctor.getParameterTypes().length, extraCtorArgs.length + 1));
        }
        Class<?>[] paramTypes = ctor.getParameterTypes();
        for (int i = 0; i < extraCtorArgs.length; ++i) {
            if (paramTypes[i + 1].isAssignableFrom(extraCtorArgs[i].getClass())) continue;
            throw new IllegalArgumentException(String.format("Additional argument %d is not compatible with construct argument", i));
        }
    }

    @Override
    public Object buildFor(Object object) {
        Object[] args = new Object[this.extraCtorArgs.length + 1];
        args[0] = object;
        if (this.extraCtorArgs.length > 0) {
            System.arraycopy(this.extraCtorArgs, 0, args, 1, this.extraCtorArgs.length);
        }
        try {
            return this.ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate surrogate instance", e);
        }
    }
}

