/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.model.commit;

import com.atlassian.stash.avatar.AvatarRequest;
import com.atlassian.stash.commit.Commit;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestPerson;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.rest.enrich.AvatarEnricher;
import com.atlassian.stash.rest.model.commit.RestMinimalCommit;
import com.atlassian.stash.rest.util.RestUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=Commit.class)
public class RestCommit
extends RestMinimalCommit {
    public static final Function<Commit, RestCommit> REST_TRANSFORM = new Function<Commit, RestCommit>(){

        public RestCommit apply(Commit commit) {
            return new RestCommit(commit);
        }
    };
    public static final RestCommit EXAMPLE = new RestCommit("abcdef0123abcdef4567abcdef8987abcdef6543", "abcdef0123a", RestPerson.EXAMPLE, new Date(), "WIP on feature 1", Lists.newArrayList((Object[])new RestMinimalCommit[]{RestMinimalCommit.EXAMPLE}), null, null);
    public static final RestCommit EXAMPLE_ALT = new RestCommit("def0123abcdef4567abcdef8987abcdef6543abc", "def0123abcd", RestPerson.EXAMPLE, new Date(), "More work on feature 1", Lists.newArrayList((Object[])new RestMinimalCommit[]{RestMinimalCommit.EXAMPLE}), null, null);
    public static final RestPage<RestCommit> PAGE_EXAMPLE = RestDocletHelper.decorate(RestDocletHelper.pageOf(EXAMPLE_ALT), ImmutableMap.of((Object)"authorCount", (Object)1, (Object)"totalCount", (Object)1));

    public RestCommit(Commit commit) {
        this(commit.getId(), commit.getDisplayId(), (RestPerson)RestPerson.REST_TRANSFORM.apply((Object)commit.getAuthor()), commit.getAuthorTimestamp(), commit.getMessage(), (Collection<RestMinimalCommit>)ImmutableList.copyOf(RestMapEntity.transform(commit.getParents(), RestMinimalCommit.REST_TRANSFORM)), (Map<String, Set<String>>)commit.getAttributes(), (Map<String, Object>)commit.getProperties());
    }

    private RestCommit(String id, String displayId, RestPerson author, Date authorTimestamp, String message, Collection<RestMinimalCommit> parents, Map<String, Set<String>> attributes, Map<String, Object> properties) {
        super(id, displayId);
        this.putIfNotNull("author", author);
        this.put("authorTimestamp", authorTimestamp);
        this.put("message", message);
        this.put("parents", parents);
        this.putIfNotEmpty("attributes", attributes);
        this.putIfNotEmpty("properties", properties);
    }

    public static Function<Commit, RestCommit> createTransformer(@Nonnull ContainerRequest request, final @Nonnull AvatarEnricher avatarEnricher) {
        final AvatarRequest avatarRequest = RestUtils.makeAvatarRequest(request);
        if (avatarRequest == null) {
            return REST_TRANSFORM;
        }
        return new Function<Commit, RestCommit>(){

            public RestCommit apply(Commit commit) {
                RestCommit restCommit = new RestCommit(commit);
                avatarEnricher.enrich(restCommit, avatarRequest);
                return restCommit;
            }
        };
    }
}

