/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.exception;

import com.atlassian.stash.commit.NoSuchCommitException;
import com.atlassian.stash.exception.ArgumentValidationException;
import com.atlassian.stash.exception.AuthenticationRequiredException;
import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.exception.EntityOutOfDateException;
import com.atlassian.stash.exception.FeatureDisabledException;
import com.atlassian.stash.exception.ForbiddenException;
import com.atlassian.stash.exception.IllegalEntityStateException;
import com.atlassian.stash.exception.IncompatibleLicenseChangeException;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.InvalidLicenseException;
import com.atlassian.stash.exception.LicenseLimitException;
import com.atlassian.stash.exception.LimitExceededException;
import com.atlassian.stash.exception.NoSuchChangesetException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.exception.PageStartOutOfBoundsException;
import com.atlassian.stash.exception.RequestCanceledException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.pull.DuplicatePullRequestException;
import com.atlassian.stash.pull.InvalidPullRequestReviewersException;
import com.atlassian.stash.pull.PullRequestMergeVetoedException;
import com.atlassian.stash.pull.UnmodifiablePullRequestRoleException;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestAuthenticationRequiredErrorMessage;
import com.atlassian.stash.rest.data.RestCommunicationErrorMessage;
import com.atlassian.stash.rest.data.RestDuplicatePullRequestErrorMessage;
import com.atlassian.stash.rest.data.RestDuplicateRefMessage;
import com.atlassian.stash.rest.data.RestEntityOutOfDateErrorMessage;
import com.atlassian.stash.rest.data.RestErrorMessage;
import com.atlassian.stash.rest.data.RestErrors;
import com.atlassian.stash.rest.data.RestInvalidPullRequestReviewersErrorMessage;
import com.atlassian.stash.rest.data.RestInvalidRefNameMessage;
import com.atlassian.stash.rest.data.RestMergeErrorMessage;
import com.atlassian.stash.rest.data.RestPullRequestMergeVetoedErrorMessage;
import com.atlassian.stash.rest.data.RestPullRequestOutOfDateErrorMessage;
import com.atlassian.stash.rest.data.RestRequestCanceledMessage;
import com.atlassian.stash.rest.renderer.AggregateBuilder;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.atlassian.stash.scm.MergeException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceExceptionMapper
implements ExceptionMapper<ServiceException> {
    public static final Map<Class<? extends ServiceException>, Response.Status> STATUS_MAP;
    private static final Logger log;
    private final AggregateBuilder exceptionMessageBuilder;

    public ServiceExceptionMapper(NavBuilder navBuilder) {
        this.exceptionMessageBuilder = new AggregateBuilder(navBuilder);
        this.registerSurrogate(RestAuthenticationRequiredErrorMessage.class);
        this.registerSurrogate(RestCommunicationErrorMessage.class);
        this.registerSurrogate(RestDuplicatePullRequestErrorMessage.class);
        this.registerSurrogate(RestEntityOutOfDateErrorMessage.class);
        this.registerSurrogate(RestErrorMessage.class);
        this.registerSurrogate(RestInvalidPullRequestReviewersErrorMessage.class);
        this.registerSurrogate(RestMergeErrorMessage.class);
        this.registerSurrogate(RestPullRequestMergeVetoedErrorMessage.class);
        this.registerSurrogate(RestPullRequestOutOfDateErrorMessage.class);
        this.registerSurrogate(RestRequestCanceledMessage.class);
        this.registerSurrogate(RestDuplicateRefMessage.class);
        this.registerSurrogate(RestInvalidRefNameMessage.class);
    }

    public Response toResponse(ServiceException e) {
        if (e instanceof NoSuchCommitException) {
            e = ServiceExceptionMapper.toChangesetException((NoSuchCommitException)e);
        }
        RestErrors errors = new RestErrors((RestErrorMessage)this.exceptionMessageBuilder.buildFor(e));
        Response response = this.createResponseBuilder(e).entity((Object)errors).type("application/json;charset=UTF-8").build();
        log.debug("Mapping ServiceException to REST response " + response.getStatus(), (Throwable)e);
        return response;
    }

    @Deprecated
    private static ServiceException toChangesetException(NoSuchCommitException e) {
        NoSuchChangesetException nsce = new NoSuchChangesetException(e.getKeyedMessage(), e.getCommitId());
        Throwable cause = e.getCause();
        if (cause != null) {
            nsce.initCause(cause);
        }
        return nsce;
    }

    private void registerSurrogate(Class<? extends RestErrorMessage> surrogateClass) {
        Preconditions.checkArgument((boolean)surrogateClass.isAnnotationPresent(JsonSurrogate.class), (Object)(surrogateClass.getName() + " is not annotated as a surrogate"));
        Preconditions.checkArgument((boolean)RestErrorMessage.class.isAssignableFrom(surrogateClass), (Object)(surrogateClass.getName() + " must derive from RestErrorMessage"));
        Preconditions.checkArgument((boolean)ServiceException.class.isAssignableFrom(surrogateClass.getAnnotation(JsonSurrogate.class).value()), (Object)(surrogateClass.getAnnotation(JsonSurrogate.class).value().getName() + " must derive from ServiceException"));
        this.exceptionMessageBuilder.registerSurrogate(surrogateClass);
    }

    private Response.ResponseBuilder createResponseBuilder(ServiceException e) {
        Class<?> clazz = e.getClass();
        while (ServiceException.class.isAssignableFrom(clazz)) {
            Response.Status status = STATUS_MAP.get(clazz);
            if (status != null) {
                return ResponseFactory.status(status);
            }
            clazz = clazz.getSuperclass();
        }
        return ResponseFactory.serverError();
    }

    static {
        log = LoggerFactory.getLogger(ServiceExceptionMapper.class);
        STATUS_MAP = ImmutableMap.builder().put(ArgumentValidationException.class, (Object)Response.Status.BAD_REQUEST).put(AuthenticationRequiredException.class, (Object)Response.Status.OK).put(AuthorisationException.class, (Object)Response.Status.UNAUTHORIZED).put(DuplicatePullRequestException.class, (Object)Response.Status.CONFLICT).put(EntityOutOfDateException.class, (Object)Response.Status.CONFLICT).put(FeatureDisabledException.class, (Object)Response.Status.CONFLICT).put(ForbiddenException.class, (Object)Response.Status.FORBIDDEN).put(IllegalEntityStateException.class, (Object)Response.Status.CONFLICT).put(IntegrityException.class, (Object)Response.Status.CONFLICT).put(InvalidPullRequestReviewersException.class, (Object)Response.Status.CONFLICT).put(InvalidLicenseException.class, (Object)Response.Status.BAD_REQUEST).put(LicenseLimitException.class, (Object)Response.Status.FORBIDDEN).put(LimitExceededException.class, (Object)Response.Status.BAD_REQUEST).put(IncompatibleLicenseChangeException.class, (Object)Response.Status.CONFLICT).put(MergeException.class, (Object)Response.Status.CONFLICT).put(NoSuchEntityException.class, (Object)Response.Status.NOT_FOUND).put(PageStartOutOfBoundsException.class, (Object)Response.Status.NOT_FOUND).put(PullRequestMergeVetoedException.class, (Object)Response.Status.CONFLICT).put(RequestCanceledException.class, (Object)Response.Status.BAD_REQUEST).put(UnmodifiablePullRequestRoleException.class, (Object)Response.Status.CONFLICT).build();
    }
}

