/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.exception;

import com.atlassian.stash.rest.data.RestErrorMessage;
import com.atlassian.stash.rest.data.RestErrors;
import com.atlassian.stash.rest.util.ResponseFactory;
import com.atlassian.stash.validation.ConstraintNature;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    ConstraintViolationExceptionMapper() {
    }

    public Response toResponse(ConstraintViolationException exception) {
        RestErrors errors = new RestErrors();
        Response.Status status = null;
        for (ConstraintViolation violation : exception.getConstraintViolations()) {
            status = violation.getConstraintDescriptor().getPayload().contains(ConstraintNature.Conflict.class) && status != Response.Status.BAD_REQUEST ? Response.Status.CONFLICT : Response.Status.BAD_REQUEST;
            errors.addError(new RestErrorMessage(violation.getPropertyPath().toString(), violation.getMessage()));
        }
        return ResponseFactory.status(status).entity((Object)errors).type("application/json;charset=UTF-8").build();
    }
}

