/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.enrich;

import com.atlassian.stash.exception.AuthorisationException;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.repository.RepositoryCloneLinksRequest;
import com.atlassian.stash.repository.RepositoryService;
import com.atlassian.stash.rest.data.RestLink;
import com.atlassian.stash.rest.data.RestNamedLink;
import com.atlassian.stash.rest.data.RestProject;
import com.atlassian.stash.rest.data.RestPullRequest;
import com.atlassian.stash.rest.data.RestRelatedLinks;
import com.atlassian.stash.rest.data.RestRepository;
import com.atlassian.stash.rest.data.RestStashUser;
import com.atlassian.stash.rest.enrich.LinkEnricher;
import com.atlassian.stash.rest.util.RestUtils;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLinkEnricher
implements LinkEnricher {
    private static final Logger log = LoggerFactory.getLogger(DefaultLinkEnricher.class);
    private final NavBuilder navBuilder;
    private RepositoryService repositoryService;

    public DefaultLinkEnricher(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    @Override
    public void enrich(@Nonnull Object entity) {
        RestUtils.processEntities(entity, new Function<Object, Object>(){

            public Object apply(Object entity) {
                if (entity instanceof RestStashUser) {
                    DefaultLinkEnricher.this.enrichStashUser((RestStashUser)entity);
                } else if (entity instanceof RestRepository) {
                    DefaultLinkEnricher.this.enrichRepository((RestRepository)entity);
                } else if (entity instanceof RestProject) {
                    DefaultLinkEnricher.this.enrichProject((RestProject)entity);
                } else if (entity instanceof RestPullRequest) {
                    DefaultLinkEnricher.this.enrichPullRequest((RestPullRequest)entity);
                }
                return entity;
            }
        });
    }

    private void enrichPullRequest(RestPullRequest pullRequest) {
        RestRepository repository = pullRequest.getToRef().getRepository();
        String projectKey = repository.getProject().getKey();
        String slug = repository.getSlug();
        long id = pullRequest.getId();
        pullRequest.setSelfLink(new RestLink("self", this.navBuilder.project(projectKey).repo(slug).pullRequest(id).buildRelNoContext()));
        pullRequest.setLinks(new RestRelatedLinks.Builder().addRelatedLinks("self", Collections.singleton(new RestNamedLink(this.navBuilder.project(projectKey).repo(slug).pullRequest(id).buildAbsolute()))).build());
    }

    private void enrichProject(RestProject project) {
        project.setSelfLink(new RestLink("self", this.navBuilder.project((Project)project).buildRelNoContext()));
        project.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", new RestNamedLink(this.navBuilder.project((Project)project).buildAbsolute())).build());
    }

    private void enrichStashUser(RestStashUser person) {
        person.setProfileUrl(this.navBuilder.user((StashUser)person).buildRelNoContext());
        person.setLinks(new RestRelatedLinks.Builder().addRelatedLink("self", new RestNamedLink(this.navBuilder.user((StashUser)person).buildAbsolute())).build());
    }

    private void enrichRepository(RestRepository restRepository) {
        NavBuilder.Repo repoNav = this.navBuilder.project(restRepository.getProject().getKey()).repo(restRepository.getSlug());
        restRepository.setSelfLink(new RestLink("self", repoNav.browse().buildRelNoContext()));
        restRepository.setCloneUrl(repoNav.clone(restRepository.getScmId()).buildAbsolute());
        RestRelatedLinks.Builder linkBuilder = new RestRelatedLinks.Builder().addRelatedLink("self", new RestNamedLink(repoNav.browse().buildAbsolute()));
        Repository repository = null;
        try {
            repository = this.repositoryService.getById(restRepository.getId().intValue());
            if (repository == null) {
                log.debug("Unable to enrich REST repository with ID {}: failed to look up repository", (Object)restRepository.getId());
            }
        }
        catch (AuthorisationException e) {
            log.debug("Skipping enrichment of REST repository with ID {} as it is not accessible to the current user", (Object)restRepository.getId());
        }
        catch (Exception e) {
            log.warn("Failed to enrich REST repository with ID {}: error while looking up repository", (Object)restRepository.getId(), (Object)e);
        }
        if (repository != null) {
            linkBuilder.addRelatedLinks("clone", Collections2.transform((Collection)this.repositoryService.getCloneLinks(new RepositoryCloneLinksRequest.Builder().repository(repository).build()), RestNamedLink.REST_TRANSFORM));
        }
        restRepository.setLinks(linkBuilder.build());
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

