/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data.cluster;

import com.atlassian.stash.cluster.ClusterInformation;
import com.atlassian.stash.cluster.ClusterNode;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.cluster.RestClusterNode;
import com.atlassian.stash.util.Chainable;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=ClusterInformation.class)
public class RestClusterInformation
extends RestMapEntity {
    public static final RestClusterInformation EXAMPLE = new RestClusterInformation(new ExampleClusterInformation());

    public RestClusterInformation(ClusterInformation information) {
        this.put("localNode", new RestClusterNode(information.getLocalNode()));
        this.put("nodes", Chainable.chain((Iterable)information.getNodes()).transform(RestClusterNode.REST_TRANSFORM).toSet());
        this.put("running", information.isRunning());
    }

    private static class ExampleClusterInformation
    implements ClusterInformation {
        private ExampleClusterInformation() {
        }

        @Nonnull
        public ClusterNode getLocalNode() {
            return new ExampleClusterNode(InetSocketAddress.createUnresolved("foo", 5000), "d4fde8b1-2504-4998-a0ba-14fbe98edd4d", true, "foo");
        }

        @Nonnull
        public Set<ClusterNode> getNodes() {
            return new HashSet<ClusterNode>(){
                {
                    this.add(new ExampleClusterNode(InetSocketAddress.createUnresolved("foo", 5000), "d4fde8b1-2504-4998-a0ba-14fbe98edd4d", true, "foo"));
                    this.add(new ExampleClusterNode(InetSocketAddress.createUnresolved("bar", 5001), "73518909-8e86-445b-8345-fcbf2e0934b6", false, "bar"));
                }
            };
        }

        public boolean isRunning() {
            return true;
        }

        private static class ExampleClusterNode
        implements ClusterNode {
            private InetSocketAddress address;
            private String id;
            private boolean isLocal;
            private String name;

            public ExampleClusterNode(InetSocketAddress address, String id, boolean isLocal, String name) {
                this.address = address;
                this.id = id;
                this.isLocal = isLocal;
                this.name = name;
            }

            @Nonnull
            public InetSocketAddress getAddress() {
                return this.address;
            }

            @Nonnull
            public String getId() {
                return this.id;
            }

            public boolean isLocal() {
                return this.isLocal;
            }

            @Nonnull
            public String getName() {
                return this.name;
            }
        }
    }
}

