/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestLink;
import com.atlassian.stash.rest.data.RestLinkedMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.data.RestPerson;
import com.atlassian.stash.rest.data.RestRelatedLinks;
import com.atlassian.stash.rest.docs.ExampleDetailedUser;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.StashUserVisitor;
import com.atlassian.stash.user.UserType;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=StashUser.class)
public class RestStashUser
extends RestPerson
implements StashUser {
    public static final String ACTIVE = "active";
    public static final String DISPLAY_NAME = "displayName";
    public static final String ID = "id";
    public static final String SLUG = "slug";
    @Deprecated
    public static final String LINK = "link";
    private static final String TYPE = "type";
    public static final Function<StashUser, RestStashUser> REST_TRANSFORM = new Function<StashUser, RestStashUser>(){

        public RestStashUser apply(StashUser input) {
            return new RestStashUser(input);
        }
    };
    public static final RestStashUser RESPONSE_EXAMPLE = new RestStashUser((StashUser)ExampleDetailedUser.EXAMPLE);
    public static final RestPage<RestStashUser> PAGE_EXAMPLE = RestDocletHelper.pageOf(RESPONSE_EXAMPLE);

    public RestStashUser(StashUser user) {
        super((Person)user);
        this.put(ID, user.getId());
        this.put(DISPLAY_NAME, user.getDisplayName());
        this.put(ACTIVE, user.isActive());
        this.put(SLUG, user.getSlug());
        this.put(TYPE, user.getType().name());
    }

    private RestStashUser(Map<String, Object> map) {
        super(map);
    }

    public <T> T accept(@Nonnull StashUserVisitor<T> visitor) {
        return (T)visitor.visit((StashUser)this);
    }

    @Nonnull
    public String getDisplayName() {
        return this.getStringProperty(DISPLAY_NAME);
    }

    @Nullable
    public Integer getId() {
        return this.getIntProperty(ID);
    }

    @Nonnull
    public String getSlug() {
        return this.getStringProperty(SLUG);
    }

    @Nonnull
    public UserType getType() {
        return this.getEnumProperty(TYPE, UserType.class);
    }

    public boolean isActive() {
        return this.getBoolProperty(ACTIVE);
    }

    @Deprecated
    public void setProfileUrl(String profileUrl) {
        RestLinkedMapEntity.setSelfLink(this, new RestLink("self", profileUrl));
    }

    public void setLinks(RestRelatedLinks links) {
        RestLinkedMapEntity.setLinks(this, links);
    }

    public static RestStashUser valueOf(Object value) {
        if (value instanceof RestStashUser) {
            return (RestStashUser)value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new RestStashUser(map);
        }
        return null;
    }
}

