/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestLicenseStatus;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.google.common.collect.ImmutableMap;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=StashLicense.class)
public class RestStashLicense
extends RestMapEntity {
    private static final String CREATION_DATE = "creationDate";
    private static final String DAYS_BEFORE_EXPIRY = "numberOfDaysBeforeExpiry";
    private static final String DAYS_BEFORE_GRACE_PERIOD_EXPIRY = "numberOfDaysBeforeGracePeriodExpiry";
    private static final String DAYS_BEFORE_MAINTENANCE_EXPIRY = "numberOfDaysBeforeMaintenanceExpiry";
    private static final String EXPIRY_DATE = "expiryDate";
    private static final String GRACE_PERIOD_EXPIRY = "gracePeriodEndDate";
    private static final String LICENSE = "license";
    private static final String MAINTENANCE_EXPIRY = "maintenanceExpiryDate";
    private static final String MAXIMUM_NUMBER_OF_USERS = "maximumNumberOfUsers";
    private static final String PURCHASE_DATE = "purchaseDate";
    private static final String SEN = "supportEntitlementNumber";
    private static final String SERVER_ID = "serverId";
    private static final String STATUS = "status";
    private static final String UNLIMITED_NuMBER_OF_USERS = "unlimitedNumberOfUsers";
    public static final RestStashLicense RESPONSE_EXAMPLE = new RestStashLicense(){
        {
            this.put(RestStashLicense.CREATION_DATE, 1331038800000L);
            this.put(RestStashLicense.PURCHASE_DATE, 1331038800000L);
            this.put(RestStashLicense.EXPIRY_DATE, 1372493732817L);
            this.put(RestStashLicense.DAYS_BEFORE_EXPIRY, 0);
            this.put(RestStashLicense.MAINTENANCE_EXPIRY, 1372493732817L);
            this.put(RestStashLicense.DAYS_BEFORE_MAINTENANCE_EXPIRY, 0);
            this.put(RestStashLicense.GRACE_PERIOD_EXPIRY, 1372493732817L);
            this.put(RestStashLicense.DAYS_BEFORE_GRACE_PERIOD_EXPIRY, 0);
            this.put(RestStashLicense.MAXIMUM_NUMBER_OF_USERS, 12);
            this.put(RestStashLicense.UNLIMITED_NuMBER_OF_USERS, false);
            this.put(RestStashLicense.SERVER_ID, "<server ID embedded in license>");
            this.put(RestStashLicense.SEN, "<support entitlement number embedded in license>");
            this.put(RestStashLicense.LICENSE, "<encoded license text>");
            this.put(RestStashLicense.STATUS, ImmutableMap.of((Object)RestStashLicense.SERVER_ID, (Object)"<actual server ID>", (Object)"currentNumberOfUsers", (Object)2));
        }
    };
    public static final RestStashLicense UPDATE_EXAMPLE = new RestStashLicense(){
        {
            this.put(RestStashLicense.LICENSE, "<encoded license text>");
        }
    };

    public RestStashLicense() {
    }

    public RestStashLicense(StashLicense license) {
        this.put(CREATION_DATE, license.getCreationDate());
        this.put(PURCHASE_DATE, license.getPurchaseDate());
        this.put(EXPIRY_DATE, license.getExpiryDate());
        this.put(DAYS_BEFORE_EXPIRY, license.getNumberOfDaysBeforeExpiry());
        this.put(MAINTENANCE_EXPIRY, license.getMaintenanceExpiryDate());
        this.put(DAYS_BEFORE_MAINTENANCE_EXPIRY, license.getNumberOfDaysBeforeMaintenanceExpiry());
        this.put(GRACE_PERIOD_EXPIRY, license.getGracePeriodEndDate());
        this.put(DAYS_BEFORE_GRACE_PERIOD_EXPIRY, license.getNumberOfDaysBeforeGracePeriodExpiry());
        this.put(MAXIMUM_NUMBER_OF_USERS, license.isUnlimitedNumberOfUsers() ? -1 : license.getMaximumNumberOfUsers());
        this.put(UNLIMITED_NuMBER_OF_USERS, license.isUnlimitedNumberOfUsers());
        this.put(SERVER_ID, license.getServerId());
        this.put(SEN, license.getSupportEntitlementNumber());
    }

    public RestStashLicense(StashLicense license, String encodedLicense, RestLicenseStatus status) {
        this(license);
        this.put(LICENSE, encodedLicense);
        this.put(STATUS, status);
    }

    public String getLicense() {
        return this.getStringProperty(LICENSE);
    }
}

