/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.data;

import com.atlassian.stash.rest.annotations.JsonSurrogate;
import com.atlassian.stash.rest.data.RestMapEntity;
import com.atlassian.stash.rest.data.RestPage;
import com.atlassian.stash.rest.docs.RestDocletHelper;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermittedGroup;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=PermittedGroup.class)
public class RestPermittedGroup
extends RestMapEntity {
    public static final Function<PermittedGroup, RestPermittedGroup> REST_TRANSFORM = new Function<PermittedGroup, RestPermittedGroup>(){

        public RestPermittedGroup apply(PermittedGroup permittedGroup) {
            return RestPermittedGroup.fromPermittedGroup(permittedGroup);
        }
    };
    public static final RestPermittedGroup RESPONSE_EXAMPLE = new RestPermittedGroup("group_a", Permission.ADMIN);
    public static final RestPage<RestPermittedGroup> PAGE_EXAMPLE = RestDocletHelper.pageOf(RESPONSE_EXAMPLE);

    public RestPermittedGroup(PermittedGroup permittedGroup) {
        this(permittedGroup.getGroup(), permittedGroup.getPermission());
    }

    private RestPermittedGroup(String name, Permission permission) {
        this.put("group", ImmutableMap.of((Object)"name", (Object)name));
        this.put("permission", permission.name());
    }

    public static RestPermittedGroup fromPermittedGroup(PermittedGroup permittedGroup) {
        return permittedGroup != null ? new RestPermittedGroup(permittedGroup) : null;
    }
}

